% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSS.R
\name{TSS}
\alias{TSS}
\title{Total Sum of Squares (TSS)}
\usage{
TSS(data = NULL, obs, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the TSS for observed vector.
}
\details{
The TSS sum of the squared differences between the observations and its mean.
It is used as a reference error, for example, to estimate explained variance.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
TSS(obs = X)
}
}
