% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue_data_DMRfinder.R
\name{metevalue.DMRfinder}
\alias{metevalue.DMRfinder}
\title{Evalue of the DMRfinder data format}
\usage{
metevalue.DMRfinder(
  methyrate,
  DMRfinder.output,
  adjust.methods = "BH",
  sep = "\\t",
  bheader = FALSE
)
}
\arguments{
\item{methyrate}{is the methyrate file.
    - chr: Chromosome

    - pos: int Position

    - g1~g2: methylation rate data in groups}

\item{DMRfinder.output}{is the output file of DMRfinder.
    - chr: Chromosome

    - start: The positions of the start sites of the corresponding region

    - end: The positions of the end sites of the corresponding region

    - CpG: The number of CpG sites within the corresponding region

    - Control.mu: The average methylation rate in control group

    - Expt1.mu: The average methylation rate in experiment group

    - Control.Expt1.diff: The methylation difference between control and experiment groups

    - Control.Expt1.pval: P-value based on Wald-test.}

\item{adjust.methods}{is the adjust methods of e-value. It can be 'bonferroni', 'hochberg', 'holm', 'hommel', 'BH', 'BY'}

\item{sep}{seperator, default is the TAB key.}

\item{bheader}{a logical value indicating whether the DMRfinder.output file contains the names of the variables as its first line. By default, bheader = FALSE.}
}
\value{
a dataframe, the columns are (in order):

    - chr: Chromosome

    - start: The positions of the start sites of the corresponding region

    - end: The positions of the end sites of the corresponding region

    - q-value: The adjusted p-value based on BH method in MWU-test

    - methyl.diff: The difference between the group means of methylation level

    - CpGs:  The number of CpG sites within the corresponding region

    - p : p-value based on MWU-test

    - p2: p-value based on 2D KS-test

    - m1:  The absolute mean methylation level for the corresponding segment of group 1

    - m2:  The absolute mean methylation level for the corresponding segment of group 2

    - e_value: The e-value of the corresponding region
}
\description{
Perform the Evaluation for the DMRfinder data.
}
\examples{
#### DMRfinder example ####'
data(demo_DMRfinder_rate_combine)
data(demo_DMRfinder_DMRs)
}
