% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_stations_info_from}
\alias{get_stations_info_from}
\title{Get meteorological stations info}
\usage{
get_stations_info_from(
  service = c("aemet", "meteocat", "meteoclimatic", "meteogalicia", "ria"),
  options
)
}
\arguments{
\item{service}{Character with the service name (in lower case).}

\item{options}{List with the needed service options. See \code{\link{services_options}} to have more info
about the different services and their options.}
}
\value{
An sf (spatial) object with the stations metadata.
}
\description{
Obtain info and metadata for the available stations in the different services
}
\details{
Depending on the service the metadata available can be different. Also, some services only offer
info for active stations (i.e. AEMET), not historical stations, so some mismatch can occur between
the stations returned by this function and the stations returned by \code{\link{get_meteo_from}} for
historical dates.
}
\section{Cache}{

To avoid unnecessary API calls (especially in rate-limited APIs), results are cached to
memory in a \code{\link[cachem]{cache_mem}} object. This cache is limited to the actual
R session and invalidates after 24h.

This cache can be cleared with \code{\link{clear_meteospain_cache}}.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  library(meteospain)
  library(keyring)

  # AEMET (we need a key)
  # key_set('aemet')
  api_options <- aemet_options(api_key = key_get('aemet'))
  get_stations_info_from('aemet', api_options)
\dontshow{\}) # examplesIf}
}
