% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_fns_list.R
\name{clust_fns}
\alias{clust_fns}
\alias{spectral_eigen}
\alias{spectral_rot}
\alias{spectral_eigen_classic}
\alias{spectral_rot_classic}
\alias{spectral_two}
\alias{spectral_three}
\alias{spectral_four}
\alias{spectral_five}
\alias{spectral_six}
\alias{spectral_seven}
\alias{spectral_eight}
\alias{spectral_nine}
\alias{spectral_ten}
\title{Built-in clustering algorithms}
\usage{
spectral_eigen(similarity_matrix)

spectral_rot(similarity_matrix)

spectral_eigen_classic(similarity_matrix)

spectral_rot_classic(similarity_matrix)

spectral_two(similarity_matrix)

spectral_three(similarity_matrix)

spectral_four(similarity_matrix)

spectral_five(similarity_matrix)

spectral_six(similarity_matrix)

spectral_seven(similarity_matrix)

spectral_eight(similarity_matrix)

spectral_nine(similarity_matrix)

spectral_ten(similarity_matrix)
}
\arguments{
\item{similarity_matrix}{A similarity matrix.}
}
\value{
solution_data A vector of cluster assignments
}
\description{
These functions can be used when building a \code{metasnf} clustering functions
list. Each function converts a similarity matrix (matrix class object) to a
cluster solution (numeric vector). Note that these functions (or custom
clustering functions) cannot accept number of clusters as a parameter; this
value must be built into the function itself if necessary.
}
\details{
\itemize{
\item spectral_eigen: Spectral clustering where the number of clusters is based
on the eigen-gap heuristic
\item spectral_rot: Spectral clustering where the number of clusters is based
on the rotation-cost heuristic
\item spectral_(C): Spectral clustering for a C-cluster solution.
}
}
