% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_plots.R
\name{auto_plot}
\alias{auto_plot}
\title{Automatically plot features across clusters}
\usage{
auto_plot(
  solutions_matrix_row = NULL,
  data_list = NULL,
  cluster_df = NULL,
  target_list = NULL,
  return_plots = TRUE,
  save = NULL,
  jitter_width = 6,
  jitter_height = 6,
  bar_width = 6,
  bar_height = 6,
  verbose = FALSE
)
}
\arguments{
\item{solutions_matrix_row}{A single row of a solutions matrix.}

\item{data_list}{A data_list containing data to plot.}

\item{cluster_df}{Directly provide a cluster_df rather than a solutions
matrix. Useful if plotting data from label propagated results.}

\item{target_list}{A target_list containing data to plot.}

\item{return_plots}{If \code{TRUE}, the function will return a list of plots.
If FALSE, the function will instead return the full data frame used for
plotting.}

\item{save}{If a string is provided, plots will be saved and this string
will be used to prefix plot names.}

\item{jitter_width}{Width of jitter plots if save is specified.}

\item{jitter_height}{Height of jitter plots if save is specified.}

\item{bar_width}{Width of bar plots if save is specified.}

\item{bar_height}{Height of bar plots if save is specified.}

\item{verbose}{If TRUE, print progress to console.}
}
\value{
By default, returns a list of plots (class "gg", "ggplot") with
one plot for every feature in the provided data list and/or target list.
If \code{return_plots} is FALSE, will instead return a single "data.frame"
object containing every provided feature for every observation in long
format.
}
\description{
Given a single row of a solutions matrix and data provided through
\code{data_list} and/or \code{target_list} arguments, this function will
return a series of bar and/or jitter plots based on feature types.
}
