% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{mc_heatmap}
\alias{mc_heatmap}
\alias{mc_trafficlight}
\title{Plot a heatmap or traffic light plot of \code{metaconfoundr()} summaries}
\usage{
mc_heatmap(
  .df,
  legend_title = "control quality",
  sort = FALSE,
  by_group = FALSE,
  score = c("adequate", "sum", "controlled"),
  non_confounders = FALSE
)

mc_trafficlight(
  .df,
  size = 8,
  legend_title = "control quality",
  sort = FALSE,
  by_group = FALSE,
  score = c("adequate", "sum", "controlled"),
  non_confounders = FALSE
)
}
\arguments{
\item{.df}{A data frame, usually the result of \code{metaconfoundr()}}

\item{legend_title}{The legend title}

\item{sort}{Logical. Sort by confounder score? Calculated by \code{\link[=score_control]{score_control()}}}

\item{by_group}{Logical. If sorted, sort within domain?}

\item{score}{The approach used to calculate the score. \code{adequate} tests if
the study controlled at a strictly adequate level. \code{sum} treats
\code{control_quality} as an ordinal integer, summing it's values such that a
higher score has better control overall. \code{controlled} tests if any control,
including \verb{some concerns} control, is present.}

\item{non_confounders}{Logical. Include non-confounders? Default is \code{FALSE}.}

\item{size}{The size of the points in the traffic light plot}
}
\value{
a ggplot
}
\description{
\code{mc_heatmap()} and \code{mc_trafficlight()} visualize the results of
\code{metaconfoundr()}, summarizing the quality of confounder control in each
study.
}
\examples{

ipi \%>\%
  metaconfoundr() \%>\%
  dplyr::mutate(variable = stringr::str_wrap(variable, 10)) \%>\%
  mc_heatmap() +
  theme_mc() +
  facet_constructs() +
  ggplot2::guides(x = ggplot2::guide_axis(n.dodge = 2))

ipi \%>\%
  metaconfoundr() \%>\%
  mc_trafficlight() +
  geom_cochrane() +
  facet_constructs() +
  scale_fill_cochrane() +
  theme_mc() +
  ggplot2::guides(x = ggplot2::guide_axis(n.dodge = 2))

}
\seealso{
Other plots: 
\code{\link{facet_constructs}()},
\code{\link{geom_cochrane}()},
\code{\link{scale_fill_cochrane}()},
\code{\link{theme_mc}()}
}
\concept{plots}
