\name{nullmaker}
\alias{nullmaker}
\title{
Null matrix creator
}

\description{
Creates null matrices that do not have columns or rows that are completely empty. Serves as a wrapper to the commsimulator() function from the 'vegan' package.
}

\usage{
nullmaker(matrix, sims = 1000, method = "r1")
}

\arguments{
  \item{matrix}{
community data in the form of a presence absence matrix
}
  \item{sims}{
number of simulated null matrices to use in analysis
}
  \item{method}{
null model randomization method. See details.
}
}

\value{
The output is a list of length 'sims' consisting of generated null matrices
}


\references{
J. Oksanen, F.G. Blanchet, R. Kindt, P. Legendre, P.R. Minchin, R.B. O'Hara, G.L. Simpson, P. Solymos, M.H.H. Stevens and H. Wagner (2012). vegan: Community Ecology Package. R package version 2.0-4. http://CRAN.R-project.org/package=vegan
}

\author{
Tad Dallas
}

\seealso{
commsimulator()
}

\examples{
#define an interaction matrix
data(testmatrices)
intmat=testmatrices[[4]]

#creation of the null matrices
nulls=nullmaker(intmat, sims=1000,method='r1')

#output is a list of length sims with each list element corresponding to a null matrix
str(nulls)
}



\keyword{ordination}
