% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_align.R
\name{combine_peaks}
\alias{combine_peaks}
\title{Combine Peaks}
\usage{
combine_peaks(
  shifted_mat = speaq_align(),
  range = 5,
  lower_bound = 1,
  spectrum_data = NULL,
  data_path = NULL
)
}
\arguments{
\item{shifted_mat}{The matrix returned by \code{speaq_align()}.}

\item{range}{Amount of adjacent columns which are permitted to be used for
improving the alignment.}

\item{lower_bound}{Minimum amount of non-zero elements per column to trigger
the alignment improvement.}

\item{spectrum_data}{The list of deconvoluted spectra as returned by
\code{generate_lorentz_curves()} that was used to generate \code{shifted_mat}. No
longer required since version 1.2 of Metabodecon.}

\item{data_path}{If not NULL, the returned dataframes \code{long} and \code{short} are
written to \code{data_path} as "aligned_res_long.csv" and "aligned_res_short.csv".}
}
\value{
A list containing two data frames \code{long} and \code{short}. The first data frame
contains one one column for each data point in the original spectrum. The
second data frame contains only columns where at least one entry is non-zero.
}
\description{
Even after calling \code{speaq_align()}, the alignment of individual signals is
not always perfect, as 'speaq' performs a segment-wise alignment i.e. groups
of signals are aligned. For further improvements, partly filled neighboring
columns are merged.
}
\details{
Example of what the function does:

\if{html}{\out{<div class="sourceCode txt">}}\preformatted{|            | 3.56 | 3.54 | 3.51 | 3.51 | 3.50 |
|----------- |------|------|------|------|------|
| Spectrum 1 | 0.13 | 0    | 0.11 | 0    | 0    |
| Spectrum 2 | 0.13 | 0    | 0.12 | 0    | 0    |
| Spectrum 3 | 0.07 | 0    | 0    | 0    | 0    |
| Spectrum 4 | 0.08 | 0    | 0    | 0.07 | 0    |
| Spectrum 5 | 0.04 | 0    | 0.04 | 0    | 0    |
}\if{html}{\out{</div>}}

becomes

\if{html}{\out{<div class="sourceCode txt">}}\preformatted{|            | 3.56 | 3.54 | 3.51 | 3.50 |
|----------- |------|------|------|------|
| Spectrum 1 | 0.13 | 0    | 0.11 | 0    |
| Spectrum 2 | 0.13 | 0    | 0.12 | 0    |
| Spectrum 3 | 0.07 | 0    | 0    | 0    |
| Spectrum 4 | 0.08 | 0    | 0.07 | 0    |
| Spectrum 5 | 0.04 | 0    | 0.04 | 0    |
}\if{html}{\out{</div>}}

I.e. column 3 and 4 get merged, because they are in \code{range} of each other
and have no common non-zero entries.
}
\examples{
sim_subset <- metabodecon_file("bruker/sim_subset")
spectrum_data <- generate_lorentz_curves_sim(sim_subset)
shifted_mat <- speaq_align(spectrum_data = spectrum_data, verbose = FALSE)
range <- 5
lower_bound <- 1
obj <- combine_peaks(shifted_mat, range, lower_bound)
str(obj)
}
\author{
Initial version from Wolfram Gronwald.
Refactored by Tobias Schmidt in 2024.
}
