% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/70_depr.R
\name{MetaboDecon1D}
\alias{MetaboDecon1D}
\title{Deconvolute 1D NMR spectrum}
\usage{
MetaboDecon1D(
  filepath,
  filename = NA,
  file_format = "bruker",
  number_iterations = 10,
  range_water_signal_ppm = 0.1527692,
  signal_free_region = c(11.44494, -1.8828),
  smoothing_param = c(2, 5),
  delta = 6.4,
  scale_factor = c(1000, 1e+06),
  debug = FALSE,
  store_results = NULL
)
}
\arguments{
\item{filepath}{Complete path of the file folder (Notice for Bruker format: filepath needs to
be the spectrum folder containing one or more different spectra
(e.g."C:/Users/Username/Desktop/spectra_from_bruker"))}

\item{filename}{Name of the NMR file. (Notice for Bruker format: filename need to be the name
of your spectrum which is also the name of the folder) (Default: filename =
NA to analyze more spectra at once)}

\item{file_format}{Format (bruker or jcampdx) of the NMR file. (Default: file_format = "bruker")}

\item{number_iterations}{Number of iterations for the approximation of the parameters for the Lorentz
curves (Default: number_iterations=10)}

\item{range_water_signal_ppm}{Half width of the water artefact in ppm (Default:
range_water_signal=0.1527692 (e.g. for urine NMR spectra))}

\item{signal_free_region}{Row vector with two entries consisting of the ppm positions for the left and
right border of the signal free region of the spectrum. (Default:
signal_free_region=c(11.44494, -1.8828))}

\item{smoothing_param}{Row vector with two entries consisting of the number of smoothing repeats for
the whole spectrum and the number of data points (uneven) for the mean
calculation (Default: smoothing_param=c(2,5))}

\item{delta}{Defines the threshold value to distinguish between signal and noise (Default:
delta=6.4)}

\item{scale_factor}{Row vector with two entries consisting of the factor to scale the x-axis and
the factor to scale the y-axis (Default: scale_factor=c(1000,1000000))}

\item{debug}{Logical value to activate the debug mode (Default: debug=FALSE)}

\item{store_results}{Specifies whether the lorentz curve parameters \code{A}, \code{lambda} and \code{x_0} and
the approximated spectrum should be stored on disk (in addition to returning
them). If \code{store_results} is \code{NULL} (default), the user is asked
interactively where the files should be stored. If FALSE, the results are not
stored. If TRUE, the results are stored in a subdirectory of R's per-session
temporary directory.}
}
\value{
A \code{decon0} object as described in \link{metabodecon_classes}.
}
\description{
Automatic deconvolution of a 1D NMR spectrum into several Lorentz curves and
the integration of them. The NMR file needs to be in Bruker format or
jcamp-dx format.

Deprecated since metabodecon v1.2.0. Please use \code{\link[=generate_lorentz_curves]{generate_lorentz_curves()}}
instead. See examples below for usage.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{

## ATTENTION: using MetaboDecon1D() for deconvolution is deprecated. Please use
## generate_lorentz_curves() instead.

## The following example shows how a subset of the Sim dataset, consisting
## of two spectrum objects, can be deconvoluted using `MetaboDecon1D()`. The
## whole example code is wrapped into `evalwith()` to simulate user input.
## When using the function interactively, you should type in the answers to
## the questions manually.
expected_answers <- c(
     "10",   # Subfolder of your filepath, i.e. the experiment number?
     "10",   # Subsubsubfolder of filepath, i.e. the processing number?
     "y",    # Use same parameters for all spectra?
     "1",    # File to adjust all parameters.
     "n",    # Signal free region borders correct selected?
     "3.55", # Left border.
     "3.35", # Right border.
     "y",    # Signal free region borders correct selected?
     "n",    # Water artefact fully inside red vertical lines?
     "0",    # Half width range (in ppm) for the water artefact.
     "y",    # Water artefact fully inside red vertical lines?
     "n"     # Save results as text documents?
)
sim <- metabodecon_file("bruker/sim_subset")
evalwith(answers = expected_answers, {
     sim_decon <- MetaboDecon1D(sim)
})

## Deconvolute only the first spectrum of the folder "bruker/sim_subset" into
evalwith(answers = expected_answers[-(3:4)], {
     sim_decon <- MetaboDecon1D(sim, filename = "sim_01")
})

}
\references{
Haeckl, M.; Tauber, P.; Schweda, F.; Zacharias, H.U.; Altenbuchinger, M.;
Oefner, P.J.; Gronwald, W. An R-Package for the Deconvolution and Integration
of 1D NMR Data: MetaboDecon1D. Metabolites 2021, 11, 452.
https://doi.org/10.3390/metabo11070452
}
\seealso{
\code{\link[=calculate_lorentz_curves]{calculate_lorentz_curves()}},
\code{\link[=plot_triplets]{plot_triplets()}},
\code{\link[=plot_lorentz_curves_save_as_png]{plot_lorentz_curves_save_as_png()}},
\code{\link[=plot_spectrum_superposition_save_as_png]{plot_spectrum_superposition_save_as_png()}}
}
\author{
Martina Haeckl, 2021: Initial version.
Tobias Schmidt, 2024: Added parameters \code{debug} and \code{store_results}. Added
minor improvements to pass CRAN checks.
}
