% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submnet.R
\name{submnet}
\alias{submnet}
\title{Simulation of gene removal-based submodels}
\usage{
submnet(model, expr, rescue.weight = NULL, ranks = NULL, step = 1,
  draw.num = 0, gene.sets = NULL, mc.cores = 1, obj.react = NA,
  tol = SYBIL_SETTINGS("TOLERANCE"), solver = SYBIL_SETTINGS("SOLVER"),
  method = SYBIL_SETTINGS("METHOD"))
}
\arguments{
\item{model}{An object of class \code{modelorg} indicating the weighted \code{rescue} model obtained from the rescue process.}

\item{expr}{A matrix of gene expression in a given condition, with replicate per column.}

\item{rescue.weight}{A vector of rescue reaction weights. Default: NULL, the weights are computed from the given model with gene.num=1.}

\item{ranks}{A matrix of score vectors for ranking genes, with gene per row, e.g. cbind(pkm expression, relative expression). Default: NULL.}

\item{step}{An integer indicating the step in numbers of genes to remove. Default: 1, gene-by-gene removal. 
When there are many genes in the model, the step is multiplied by an exponent of 2 for later removals. 
This is to reduce the computing time for non-informative sub-models at the end of the series.}

\item{draw.num}{Number of random draws. Default: 0.}

\item{gene.sets}{Named list of gene sets for gene set enrichment analysis. Default: NULL,
depletion fraction of gene sets should be further computed for gene set enrichment analysis.}

\item{mc.cores}{The number of cores to use (at least 1), i.e. at most how many child processes will be run simultaneously. Default: 1.}

\item{obj.react}{A string indicating objective reaction ID. Default: reaction producing BIOMASS.}

\item{tol}{The maximum value to be considered null. Default: \code{SYBIL_SETTINGS("TOLERANCE")}.}

\item{solver}{\code{\link{sybil}} solver. Default: \code{SYBIL_SETTINGS("SOLVER")}.}

\item{method}{\code{\link{sybil}} method. Default: \code{SYBIL_SETTINGS("METHOD")}.}
}
\value{
An object of class \code{scoreGeneDel} for the submodel construction simulation.
}
\description{
This function simulates the construction of submodels by removing genes.
}
\examples{
data(Ec_core)
mod <- rescue(Ec_core, target=0.1)
mod.weight <- changeObjFunc(mod$rescue, react=rownames(mod$coef), obj_coef=mod$coef)
expr <- matrix(replicate(2, rnorm(length(sybil::allGenes(mod.weight)), mean=5, sd=4)), 
               ncol=2, 
               dimnames=list(sybil::allGenes(mod.weight), c('rep.1', 'rep.2')))
gene.sets <- list(X1=head(rownames(expr)), X2=tail(rownames(expr)))
sgd <- submnet(model=mod.weight,
               expr=expr, step=200, obj.react="Biomass_Ecoli_core_w_GAM", gene.sets=gene.sets)
}
