% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plot.metaRangeSimulation}
\alias{plot.metaRangeSimulation}
\title{Plotting function}
\usage{
\method{plot}{metaRangeSimulation}(x, obj, name, col, ...)
}
\arguments{
\item{x}{\verb{<metaRangeSimulation>} \link{metaRangeSimulation} object.}

\item{obj}{\verb{<string>} either the string \code{environment} or the name of a species.}

\item{name}{\verb{<string>} either the name of an environment of the name of a species trait.}

\item{col}{\verb{<character>} colors to use. Defaults to \code{grDevices::hcl.colors()} with
\code{n = 50} and a random palette.}

\item{...}{additional arguments passed to \link[terra:plot]{terra::plot} or \link[base:plot]{base::plot}.}
}
\value{
\verb{<invisible NULL>}.
}
\description{
Plots the specified element of a \link{metaRangeSimulation} object.
}
\examples{
sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2))
names(sim_env) <- "env_01"
test_sim <- metaRangeSimulation$new(source_environment = sim_env)
plot(test_sim, "environment", "env_01")

test_sim$add_species("species_01")
test_sim$add_traits("species_01", trait_01 = matrix(1, nrow = 2, ncol = 2))
plot(test_sim, "species_01", "trait_01")

test_sim$add_globals("global_01" = 1:10)
plot(test_sim, "globals", "global_01")
}
