% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_PAIRED_MC.R
\name{es_from_mean_change_ci}
\alias{es_from_mean_change_ci}
\title{Convert mean changes and standard deviations of two independent groups into standard effect size measures}
\usage{
es_from_mean_change_ci(
  mean_change_exp,
  mean_change_ci_lo_exp,
  mean_change_ci_up_exp,
  mean_change_nexp,
  mean_change_ci_lo_nexp,
  mean_change_ci_up_nexp,
  r_pre_post_exp,
  r_pre_post_nexp,
  n_exp,
  n_nexp,
  max_asymmetry = 10,
  smd_to_cor = "viechtbauer",
  reverse_mean_change
)
}
\arguments{
\item{mean_change_exp}{mean change of participants in the experimental/exposed group.}

\item{mean_change_ci_lo_exp}{lower bound of the 95\% CI around the mean change of the experimental/exposed group.}

\item{mean_change_ci_up_exp}{upper bound of the 95\% CI around the mean change of the experimental/exposed group.}

\item{mean_change_nexp}{mean change of participants in the non-experimental/non-exposed group.}

\item{mean_change_ci_lo_nexp}{lower bound of the 95\% CI around the mean change of the non-experimental/non-exposed group.}

\item{mean_change_ci_up_nexp}{upper bound of the 95\% CI around the mean change of the non-experimental/non-exposed group.}

\item{r_pre_post_exp}{pre-post correlation in the experimental/exposed group}

\item{r_pre_post_nexp}{pre-post correlation in the non-experimental/non-exposed group}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{max_asymmetry}{A percentage indicating the tolerance before detecting asymmetry in the 95\% CI bounds.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_mean_change}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 14. Paired: mean change, and dispersion'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert mean changes and standard deviations of two independent groups into standard effect size measures
}
\details{
This function converts the mean change and 95\% CI of two independent groups
into a Cohen's d. The Cohen's d is then converted to other effect size measures.

This function simply internally calls the \code{\link{es_from_means_ci_pre_post}} function but setting:
\deqn{mean\_pre\_exp = mean\_change\_exp}
\deqn{mean\_pre\_ci\_lo\_exp = mean\_change\_ci\_lo\_exp}
\deqn{mean\_pre\_ci\_up\_exp = mean\_change\_ci\_up\_exp}

\deqn{mean\_exp = 0}
\deqn{mean\_ci\_lo\_exp = 0}
\deqn{mean\_ci\_up\_exp = 0}

\deqn{mean\_pre\_nexp = mean\_change\_nexp}
\deqn{mean\_pre\_ci\_lo\_nexp = mean\_change\_ci\_lo\_nexp}
\deqn{mean\_pre\_ci\_up\_nexp = mean\_change\_ci\_up\_nexp}

\deqn{mean\_nexp = 0}
\deqn{mean\_ci\_lo\_nexp = 0}
\deqn{mean\_ci\_up\_nexp = 0}

To know more about the calculations, see \code{\link{es_from_means_sd_pre_post}} function.
}
\examples{
es_from_mean_change_ci(
  n_exp = 36, n_nexp = 35,
  mean_change_exp = 8.4,
  mean_change_ci_lo_exp = 6.4, mean_change_ci_up_exp = 10.4,
  mean_change_nexp = 2.43,
  mean_change_ci_lo_nexp = 1.43, mean_change_ci_up_nexp = 3.43,
  r_pre_post_exp = 0.2, r_pre_post_nexp = 0.2
)
}
\references{
Bonett, S. B. (2008). Estimating effect sizes from pretest-posttest-control group designs. Organizational Research Methods, 11(2), 364–386. https://doi.org/10.1177/1094428106291059

Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
