% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.meta.R
\name{print.meta}
\alias{print.meta}
\alias{cilayout}
\title{Print meta-analysis results}
\usage{
\method{print}{meta}(
  x,
  sortvar,
  comb.fixed = x$comb.fixed,
  comb.random = x$comb.random,
  prediction = x$prediction,
  details = FALSE,
  ma = TRUE,
  overall = x$overall,
  overall.hetstat = x$overall.hetstat,
  backtransf = x$backtransf,
  pscale = x$pscale,
  irscale = x$irscale,
  irunit = x$irunit,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  digits.I2 = gs("digits.I2"),
  digits.prop = gs("digits.prop"),
  digits.weight = gs("digits.weight"),
  big.mark = gs("big.mark"),
  text.tau2 = gs("text.tau2"),
  text.tau = gs("text.tau"),
  text.I2 = gs("text.I2"),
  warn.backtransf = FALSE,
  ...
)

cilayout(bracket = "[", separator = "; ")
}
\arguments{
\item{x}{An object of class \code{meta}}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as \code{x$TE}).}

\item{comb.fixed}{A logical indicating whether a fixed effect
meta-analysis should be conducted.}

\item{comb.random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{details}{A logical indicating whether further details of
individual studies should be printed.}

\item{ma}{A logical indicating whether the summary results of the
meta-analysis should be printed.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{backtransf}{A logical indicating whether printed results
should be back transformed. If \code{backtransf = TRUE}, results
for \code{sm = "OR"} are printed as odds ratios rather than log
odds ratios and results for \code{sm = "ZCOR"} are printed as
correlations rather than Fisher's z transformed correlations, for
example.}

\item{pscale}{A numeric giving scaling factor for printing of
single event probabilities or risk differences, i.e. if argument
\code{sm} is equal to \code{"PLOGIT"}, \code{"PLN"},
\code{"PRAW"}, \code{"PAS"}, \code{"PFT"}, or \code{"RD"}.}

\item{irscale}{A numeric defining a scaling factor for printing of
single incidence rates or incidence rate differences, i.e. if
argument \code{sm} is equal to \code{"IR"}, \code{"IRLN"},
\code{"IRS"}, \code{"IRFT"}, or \code{"IRD"}.}

\item{irunit}{A character specifying the time unit used to
calculate rates, e.g. person-years.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
deviations and standard errors, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance, see \code{print.default}.}

\item{digits.tau}{Minimal number of significant digits for square
root of between-study variance, see \code{print.default}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
and Rb statistic, see \code{print.default}.}

\item{digits.prop}{Minimal number of significant digits for
proportions, see \code{print.default}.}

\item{digits.weight}{Minimal number of significant digits for
weights, see \code{print.default}.}

\item{big.mark}{A character used as thousands separator.}

\item{text.tau2}{Text printed to identify between-study variance
\eqn{\tau^2}.}

\item{text.tau}{Text printed to identify \eqn{\tau}, the square
root of the between-study variance \eqn{\tau^2}.}

\item{text.I2}{Text printed to identify heterogeneity statistic
I\eqn{^2}.}

\item{warn.backtransf}{A logical indicating whether a warning
should be printed if backtransformed proportions and rates are
below 0 and backtransformed proportions are above 1.}

\item{\dots}{Additional arguments (passed on to
\code{\link{print.summary.meta}} called internally).}

\item{bracket}{A character with bracket symbol to print lower
confidence interval: "[", "(", "\{", "".}

\item{separator}{A character string with information on separator
between lower and upper confidence interval.}
}
\description{
Print method for objects of class \code{meta}.
}
\details{
R function cilayout can be utilised to change the layout to print
confidence intervals (both in printout from print.meta and
print.summary.meta function as well as in forest plots). The
default layout is "[lower; upper]". Another popular layout is
"(lower - upper)" which is used throughout an R session by using R
command \code{cilayout("(", " - ")}.

Argument \code{pscale} can be used to rescale single proportions or
risk differences, e.g. \code{pscale = 1000} means that proportions
are expressed as events per 1000 observations. This is useful in
situations with (very) low event probabilities.

Argument \code{irscale} can be used to rescale single rates or rate
differences, e.g. \code{irscale = 1000} means that rates are
expressed as events per 1000 time units, e.g. person-years. This is
useful in situations with (very) low rates. Argument \code{irunit}
can be used to specify the time unit used in individual studies
(default: "person-years"). This information is printed in summaries
and forest plots if argument \code{irscale} is not equal to 1.
}
\examples{
data(Fleiss93cont)
m1 <- metacont(n.e, mean.e, sd.e, n.c, mean.c, sd.c,
               data = Fleiss93cont, sm = "SMD",
               studlab = paste(study, year))
m1

print(m1, digits = 2)

\dontrun{
# Use unicode characters to print tau^2, tau, and I^2 
print(m1,
      text.tau2 = "\u03c4\u00b2", text.tau = "\u03c4", text.I2 = "I\u00b2")
}

}
\references{
Cooper H & Hedges LV (1994), \emph{The Handbook of
  Research Synthesis}.  Newbury Park, CA: Russell Sage Foundation.

Crippa A, Khudyakov P, Wang M, Orsini N, Spiegelman D (2016), A new measure
of between-studies heterogeneity in meta-analysis.  \emph{Statistics in
Medicine}, \bold{35}, 3661--75.

Higgins JPT & Thompson SG (2002), Quantifying heterogeneity in a
meta-analysis.  \emph{Statistics in Medicine}, \bold{21}, 1539--58.
}
\seealso{
\code{\link{summary.meta}}, \code{\link{update.meta}},
  \code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
