% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce_from_messydate.R
\name{from_messydate}
\alias{from_messydate}
\alias{as.Date.mdate}
\alias{as.POSIXct.mdate}
\alias{as.POSIXlt.mdate}
\title{Coercion from messy dates}
\usage{
\method{as.Date}{mdate}(x, ..., FUN)

\method{as.POSIXct}{mdate}(x, ..., FUN)

\method{as.POSIXlt}{mdate}(x, ..., FUN)
}
\arguments{
\item{x}{A \code{mdate} object}

\item{...}{Arguments passed on to the S3 generics.}

\item{FUN}{A function that can be used to resolve expanded messy dates
into a single date.
For example, \code{min()}, \code{max()}, \code{mean()}, \code{median()},
\code{modal()}, and \code{random()}.}
}
\value{
A date object of \code{Date}, \code{POSIXct}, or \code{POSIXlt} class
}
\description{
These functions coerce objects of \code{mdate} class to
common date classes such as \code{Date}, \code{POSIXct}, and \code{POSIXlt}.
Since \code{mdate} objects can hold multiple individual dates,
however, an additional function must be passed as an argument
so that these functions know how to coerce resolve multiple dates
into a single date.

For example, one might wish to use the earliest possible date
in any ranges of dates (\code{min}), the latest possible date (\code{max}),
some notion of a central tendency (\code{mean}, \code{median}, or \code{modal}),
or even a \code{random} selection from among the candidate dates.

These functions then, building on \code{expand()} and the resolve functions,
are particularly useful in converting back out of the \code{mdate} class
for use with existing methods and models,
especially for checking the robustness of results.
}
\examples{
as.Date(as_messydate("2012-01"), min)
as.Date(as_messydate("2012-01-01"), mean)
as.Date(as_messydate("2012-01"), max)
as.Date(as_messydate("2012-01"), median)
as.Date(as_messydate("2012-01"), modal)
as.Date(as_messydate("2012-01"), random)
as.Date(as_messydate("1000 BC"), max)
as.Date(as_messydate("1000 BC"), mean)
as.Date(as_messydate("1000 BC"), median)
as.Date(as_messydate(c("-1000", "2020")), min)
}
