% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{search_rw}
\alias{search_rw}
\title{Search network using switcher-random walk process}
\usage{
search_rw(adjlist, start, observe, nmax = 1000L, pjump = 0,
  type = 0L)
}
\arguments{
\item{adjlist}{a list containing row indices of nodes adjacent node to the ith
node as created by \link{get_adjlist}.}

\item{start}{integer vector of length 1 or larger specifying the index of
the start node.}

\item{observe}{integer vector of length 1 or larger specifying the target
end nodes.}

\item{nmax}{integer specifying the maximum number of steps before search
terminates.}

\item{pjump}{numeric specifying the probability of a jump.}

\item{type}{integer controlling network start and jump nodes.
For \code{type = 0} the process selects the start node and any jump
nodes proportional to their degree. For \code{type = 1} the process
selects a random node to serve both as the start node and the jump node.
For \code{type = 2} the process selects the start and any jump nodes
uniformly at random.}
}
\value{
Numeric, 3 column matrix containing in each row the start node, the
end node, and the (minimum) number of steps it took to reach the end node
from the start node.
}
\description{
Traverses a network using a switcher-random walk process and records the
number of steps required to get from node \code{start} to node \code{observe}.
}
\details{
If a node specified in \code{observe} has never been visited then the function
returns \code{nmax} for that node.
}
\examples{
# generate watts strogatz graph
network = grow_ws(n = 100, k = 10)

# observe number of steps from node 2 and 6
# to nodes 3, 4, and 5
search_rw(get_adjlist(network), c(2, 6), c(3, 4, 5))

# observe number of steps from node 2 and 6 to nodes 3, 4, and 5
# with high jump probability
search_rw(get_adjlist(network), start = c(2, 6), observe = c(3, 4, 5), pjump = .5)

}
\references{
Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
differences in the semantic networks of younger and older adults.
https://doi.org/10.31234/osf.io/s73dp

Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
inspired mechanism for network exploration. International Journal of
Bifurcation and Chaos, 20(03), 913-922.
}
