% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{restore_names}
\alias{restore_names}
\title{Restore names of memnet objects}
\usage{
restore_names(dat, names)
}
\arguments{
\item{dat}{lists of indices that correspond to positions in a name vector or
matrix with two initial columns containing node indices.}

\item{names}{character vector giving the names.}
}
\value{
lists of character vectors.
}
\description{
Function replaces the index vectors created by \link{get_adjlist}
\link{fluency}, or \link{search_rw} by their original names.
}
\examples{

# get fluency data
data(animal_fluency)

# edge list of fluency graph
edge_list = threshold_graph(animal_fluency)

# extract adjlist from community network
adjlist = edg_to_adjlist(edge_list)

f = fluency(adjlist, c(10, 14, 16, 18))
restore_names(f, get_names(edge_list))

}
