% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{framing}
\alias{framing}
\title{Brader, Valentino and Suhay (2008) Framing Experiment Data}
\format{A data frame containing the following variables: 
\describe{ 
  \item{immigr:}{ A four-point scale measuring subjects' attitudes toward
  increased immigration. Larger values indicate more negative attitudes.} 
  \item{english:}{ A four-point scale indicating whether subjects favor or 
  oppose a law making English the official language of the U.S.} 
  \item{cong_mesg:}{ Whether subjects requested sending an anti-immigration 
  message to Congress on their behalf.} \item{anti_info:}{ Whether subjects
  wanted to receive information from anti-immigration organizations.} 
  \item{tone:}{ 1st treatment; whether the news story is framed positively or
  negatively.} \item{eth:}{ 2nd treatment; whether the news story features a
  Latino or European immigrant.} \item{cond:}{ Four level measure recording
  joint treatment status of tone and eth.} \item{treat:}{ Product of the two
  treatment variables. In the original study the authors only find this cell
  to be significant.} \item{emo:}{ Measure of subjects' negative feeling
  during the experiment. A numeric scale ranging between 3 and 12 where 3
  indicates the most negative feeling.} \item{anx:}{ A four-point scale
  measuring subjects' anxiety about increased immigration.} \item{p_harm:}{
  Subjects' perceived harm caused by increased immigration. A numeric scale
  between 2 and 8.} \item{age:}{ Subjects' age.} \item{educ:}{ Subjects'
  highest educational attainments.} \item{gender:}{ Subjects' gender.} 
  \item{income:}{ Subjects' income, measured as a 19-point scale.} 
}}
\source{
Brader, T., Valentino, N. and Suhay, E. (2008). What triggers public
  opposition to immigration? Anxiety, group cues, and immigration threat.
  American Journal of Political Science 52, 4, 959--978.
}
\usage{
framing
}
\description{
The \code{framing} data contains 265 rows and 15 columns of data from a 
framing experiment conducted by Brader, Valentino and Suhay (2008).
}
\keyword{datasets}
