% Generated by roxygen2 (4.0.2): do not edit by hand
\name{neModel-methods}
\alias{coef.neModel}
\alias{confint.neModelBoot}
\alias{neModel-methods}
\alias{summary.neModel}
\alias{vcov.neModelBoot}
\title{Methods for natural effect models}
\usage{
\method{coef}{neModel}(object, ...)

\method{confint}{neModelBoot}(object, parm, level = 0.95, type = "norm",
  ...)

\method{summary}{neModel}(object, ...)

\method{vcov}{neModelBoot}(object, ...)
}
\arguments{
\item{object}{a fitted natural effect model object.}

\item{...}{additional arguments (see \code{\link[boot]{boot.ci}} for \code{confint} or \code{\link[stats]{summary.glm}} for \code{summary}).}

\item{parm}{a specification of which parameters are to be given
    confidence intervals, either a vector of numbers or a vector of
    names.  If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{type}{the type of bootstrap intervals required. The default \code{"norm"} returns normal approximation bootstrap confidence intervals. Currently, only \code{"norm"}, \code{"basic"} and \code{"perc"} are supported (see \code{\link[boot]{boot.ci}}).}
}
\description{
Confidence intervals and statistical tests for natural effect models.
}
\details{
\code{vcov} returns the variance covariance matrix calculated from the bootstrap samples stored in\cr \code{object$bootRes} (see \code{\link{neModel}}).

\code{confint} yields bootstrap confidence intervals. These confidence intervals are internally called via the \code{\link[boot]{boot.ci}} function from the \pkg{boot} package.
The default confidence level specified in \code{level} (which corresponds to the \code{conf} argument in \code{\link[boot]{boot.ci}}) is 0.95
and the default type of bootstrap confidence interval, \code{"norm"}, is based on the normal approximation (for more details see \code{\link[boot]{boot.ci}}).

A summary table with large sample tests, similar to that for \code{\link[stats]{glm}} output, can be obtained using \code{summary}.
}
\note{
\emph{Z}-values in the summary table are simply calculated by dividing the parameter estimate by its corresponding bootstrap standard error.
Corresponding \emph{p}-values in the summary table are only indicative, since the null distribution for each statistic is assumed to be approximately standard normal.
Therefore, where possible, it is generally recommend to focus mainly on bootstrap confidence intervals for inference, rather than the provided \emph{p}-values.
}
\examples{
data(UPBdata)

impData <- neImpute(UPB ~ att * negaffect + educ + gender + age,
                    family = binomial, data = UPBdata)
\donttest{neMod <- neModel(UPB ~ att0 * att1 + educ + gender + age,
                 family = binomial, expData = impData)}\dontshow{neMod <- neModel(UPB ~ att0 * att1 + educ + gender + age, family = binomial, expData = impData, nBoot = 2)}

## extract coefficients
coef(neMod)

## extract (bootstrap) variance-covariance matrix
vcov(neMod)

## obtain bootstrap confidence intervals
confint(neMod)
confint(neMod, parm = c("att0"))
confint(neMod, type = "perc", level = 0.90)

## summary table
summary(neMod)
}
\seealso{
\code{\link{neModel}}, \code{\link{plot.neModel}}
}

