% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{FPR}
\alias{FPR}
\title{False positive rate}
\usage{
FPR(truth, response, negative, positive)
}
\arguments{
\item{truth}{vector of true values}

\item{response}{vector of predicted values}

\item{negative}{negative class}

\item{positive}{positive class}
}
\description{
Percentage of misclassified observations in the positive class. Also called false alarm rate or fall-out.
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
positive = 1
negative = 0
FPR(truth, response, negative, positive)
}
