% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.weight.R
\name{entropy.weight}
\alias{entropy.weight}
\title{Maximum entropy weights}
\usage{
entropy.weight(X, h)
}
\arguments{
\item{X}{n by p maxtrix containing observations of p biomarkers of n subjects.}

\item{h}{bandwidth for kernel density estimation.}
}
\description{
entropy.weight produces a set of weights that maximizes the total weighted entropy of the distribution of different biomarkers within each subject.
}
\examples{
library(MASS)
# a three biomarkers dataset generated from independent normal(0,1)
X = mvrnorm(n = 100, mu=rep(0,3), Sigma=diag(3), tol = 1e-6, empirical = FALSE, EISPACK = FALSE)
entropy.weight(X, h=1)
}
\keyword{weighting}
