% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_themes.R
\name{md_theme_gray}
\alias{md_theme_gray}
\alias{md_theme_grey}
\alias{md_theme_bw}
\alias{md_theme_linedraw}
\alias{md_theme_light}
\alias{md_theme_dark}
\alias{md_theme_minimal}
\alias{md_theme_classic}
\title{ggplot2 Markdown Themes}
\usage{
md_theme_gray(...)

md_theme_grey(...)

md_theme_bw(...)

md_theme_linedraw(...)

md_theme_light(...)

md_theme_dark(...)

md_theme_minimal(...)

md_theme_classic(...)
}
\arguments{
\item{...}{Arguments passed on to the corresponding theme in package \code{{ggplot2}}}
}
\value{
An object of class \code{theme} that can be added to any \code{ggplot}
}
\description{
\code{{ggplot2}} themes supporting markdown syntax
}
\examples{
library(ggplot2)
data(mtcars)

p <- ggplot(mtcars, aes(hp, mpg)) +
  geom_point() +
  labs(
    title = "A **bold** title",
    subtitle = "An *italics* subtitle",
    caption = "A <span style = 'color:blue'>blue</span> caption"
  )

# With a 'usual' theme the text is not rendered
p

# By adding an 'md' theme the text is rendered properly
p + md_theme_gray()

}
\seealso{
\code{\link[=as_md_theme]{as_md_theme()}}
}
