% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotseries.R
\name{plotConvexHull}
\alias{plotConvexHull}
\title{Add convex hull for groups of points on scatter plot}
\usage{
plotConvexHull(p, lwd = 1, lty = 1, opacity = 0)
}
\arguments{
\item{p}{plot data returned by function `mdaplot()`.}

\item{lwd}{thickness of line used to show the hull.}

\item{lty}{type of line used to show the hull.}

\item{opacity}{of opacity is larger than 0 a semi-transparent polygon is shown over points.}
}
\description{
The method shows convex hull for groups of points on a scatter plot made using
`mdaplot()` function with `cgroup` parameter. It will work only if `cgroup` is a factor.
}
\examples{
# adds convex hull with semi-transparent area over two clusters of points

library(mdatools)
data(people)
group <- factor(people[, "Sex"], labels = c("Male", "Female"))

p <- mdaplot(people, type = "p", cgroup = group)
plotConvexHull(p)

}
