% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcCalcTstar.r
\name{mc.calcTstar}
\alias{mc.calcTstar}
\title{Compute Resampling T-statistic.}
\usage{
mc.calcTstar(
  .Object,
  x.levels,
  iter.max = 30,
  threshold = 1e-06,
  kM = 1.345,
  tauMM = 4.685,
  priorSlope = 1,
  priorIntercept = 0,
  bdPoint = 0.5
)
}
\arguments{
\item{.Object}{object of class "MCResultResampling".}

\item{x.levels}{a numeric vector of clinical decision points of interest.}

\item{iter.max}{maximal number of iterations  for calculation of weighted Deming regression.}

\item{threshold}{threshold for calculation of weighted Deming regression.}

\item{kM}{Huber's k for the M weighting, default kM = 1.345}

\item{tauMM}{Tukey's tau for bisquare redescending weighting function, default tauMM = 4,685}

\item{priorSlope}{starting slope value for PiMMDeming, default priorSlope = 1}

\item{priorIntercept}{starting intercept value for PiMMDeming, default priorIntercept = 0}

\item{bdPoint}{Proportion of data points selected for the highly robust M regression used for the determination of the starting parameters. Default 0.5}
}
\value{
Tstar numeric vector containing resampling pivot statistic.
}
\description{
Compute Resampling T-statistic.
for Calculation of t-Bootstrap Confidence Intervals.
}
\references{
Carpenter J., Bithell J. 
             Bootstrap confidence intervals: when, which, what? A practical guide for medical statisticians.
             Stat Med, 19 (9), 1141-1164 (2000).
}
