% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpfit_methods.R
\encoding{UTF-8}
\name{tidy_samples}
\alias{tidy_samples}
\alias{tidy_samples.mcpfit}
\title{Get tidy samples with or without varying effects}
\usage{
tidy_samples(
  fit,
  population = TRUE,
  varying = TRUE,
  absolute = FALSE,
  prior = FALSE,
  nsamples = NULL
)
}
\arguments{
\item{fit}{An \code{\link{mcpfit}} object}

\item{population}{\itemize{
\item \strong{TRUE:} All population effects. Same as \code{fit$pars$population}.
\itemize{
\item \strong{FALSE:} No population effects. Same as \code{c()}.
\item \strong{Character vector:} Only include specified population parameters - see \code{fit$pars$population}.
}
}}

\item{varying}{\itemize{
\item \strong{TRUE:} All varying effects (\code{fit$pars$varying}).
\itemize{
\item \strong{FALSE:} No varying efects (\code{c()}).
\item \strong{Character vector:} Only include specified varying parameters - see \code{fit$pars$varying}.
}
}}

\item{absolute}{\itemize{
\item \strong{TRUE:} Returns the absolute location of all varying change points.
\itemize{
\item \strong{FALSE:} Just returns the varying effects.
\item \strong{Character vector:} Only do absolute transform for these varying parameters - see \code{fit$pars$varying}.
}

OBS: This currently only applies to varying change points. It is not implemented for \code{rel()} regressors yet.
}}

\item{prior}{TRUE/FALSE. Summarise prior instead of posterior?}

\item{nsamples}{Integer or \code{NULL}. Number of samples to return/summarise.
If there are varying effects, this is the number of samples from each varying group.
\code{NULL} means "all". Ignored if both are \code{FALSE}. More samples trade speed for accuracy.}
}
\value{
\code{tibble} of posterior draws in \code{tidybayes} format.
}
\description{
Returns in a format useful for \code{fit$simulate()} with population parameters in wide format
and varying effects in long format (the number of rows will be \code{nsamples * n_levels_in_varying}).
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
\keyword{internal}
