
## "JordanDecomposition" is a virtual class but there is a generic function
## JordanDecomposition() which creates suitable Jordan decomposition objects from some
## derived non-virtual class.

setClass("JordanDecomposition", contains = "VIRTUAL")

## The basic non-virtual Jordan decomposition class
setClass("JordanDecompositionDefault",
         slots = c(values = "number", heights = "integer", vectors = "matrix"),
         contains = "JordanDecomposition"
         )

# not set as a validity function for the class since can't control when it is called.
.validJD <- function(object){
    if(   length(object@values) == length(object@heights)
       && ncol(object@vectors) == sum(object@heights))
        return(TRUE)

    err <- character(0)
    if(length(object@values) != length(object@heights))
        err <- c(err, "'values' and 'heights' must have equal lengths")
    if(ncol(object@vectors) != sum(object@heights))
        err <- c(err, "the number of vectors must equal sum(heights)")
    err
}




setMethod("initialize",
          "JordanDecompositionDefault",
          function(.Object, heights, ...){
              .Object <- callNextMethod(.Object, ...)
              if(missing(heights))
                  .Object@heights <- rep(1L, length(.Object@values))
              else{
                  .Object@heights <- as.integer(heights)
              }

              status <- .validJD(.Object)
              if(is.character(status))
                  stop(paste0(status, collapse="\n"))
              .Object
          }
          )


setAs("JordanDecompositionDefault", "matrix",
      function(from){
          j <- Jordan_matrix(from@values, from@heights)
          from_Jordan(from@vectors, j)
      }
      )

as.matrix.JordanDecompositionDefault <-
    function(x, ...){
        as(x, "matrix")
    }


