% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_match.R
\name{mc_match_data}
\alias{mc_match_data}
\title{Match Monte Carlo Node with other data frame}
\usage{
mc_match_data(mcmodule, mc_name, data, keys_names = NULL)
}
\arguments{
\item{mcmodule}{Monte Carlo module}

\item{mc_name}{Node name}

\item{data}{Data frame containing keys to match with}

\item{keys_names}{Names of key columns}
}
\value{
List containing matched node, matched data and combined keys (keys_xy
}
\description{
Matches an mcnode with a data frame by:
\enumerate{
\item Group matching - Same scenarios but different group order
\item Scenario matching - Same groups but different scenarios
\item Null matching - Add missing groups across different scenarios
}
}
\examples{
test_data  <- data.frame(pathogen=c("a","b"),
                         inf_dc_min=c(0.05,0.3),
                         inf_dc_max=c(0.08,0.4))
result<-mc_match_data(imports_mcmodule,"no_detect_a", test_data)
}
