% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{subset.dc}
\alias{subset.dc}
\title{Select a subset of chains, samples and parameters from a draws component (dc) object}
\usage{
\method{subset}{dc}(
  x,
  chains = seq_len(nchains(x)),
  draws = seq_len(ndraws(x)),
  vars = seq_len(nvars(x)),
  ...
)
}
\arguments{
\item{x}{a draws component (dc) object.}

\item{chains}{an integer vector indicating which chains to select.}

\item{draws}{an integer vector indicating which samples to select.}

\item{vars}{an integer vector indicating which parameters to select.}

\item{...}{not used.}
}
\value{
The selected part of the draws component as an object of class \code{dc}.
}
\description{
Select a subset of chains, samples and parameters from a draws component (dc) object
}
\examples{
n <- 300
dat <- data.frame(x=runif(n), f=as.factor(sample(1:7, n, replace=TRUE)))
gd <- generate_data(~ reg(~ x + f, prior=pr_normal(precision=1), name="beta"), data=dat)
dat$y <- gd$y
sampler <- create_sampler(y ~ reg(~ x + f, name="beta"), data=dat)
sim <- MCMCsim(sampler)
(summary(sim$beta))
(summary(subset(sim$beta, chains=1)))
(summary(subset(sim$beta, chains=1, draws=sample(1:ndraws(sim), 100))))
(summary(subset(sim$beta, vars=1:2)))

}
