% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_base.R
\name{add_base.mcgf}
\alias{add_base.mcgf}
\alias{base<-}
\title{Add base model outputted from \code{\link[=fit_base]{fit_base()}} to an \code{mcgf} object.}
\usage{
\method{add_base}{mcgf}(x, fit_base, fit_s, fit_t, sep = FALSE, old = FALSE, ...)

base(x) <- value
}
\arguments{
\item{x}{An \code{mcgf} object.}

\item{fit_base}{Output from the \code{\link[=fit_base]{fit_base()}} function.}

\item{fit_s}{Pure spatial model outputted from the \code{\link[=fit_base]{fit_base()}} function.
Used only when \code{sep = TRUE}.}

\item{fit_t}{Pure temporal model outputted from the \code{\link[=fit_base]{fit_base()}} function.
Used only when \code{sep = TRUE}.}

\item{sep}{Logical; TRUE if spatial and temporal models are fitted
separately.}

\item{old}{Logical; TRUE if the old base model needs to be kept.}

\item{...}{Additional arguments. Not in use.}

\item{value}{A list containing the base model as well as its parameters. It
must contains the same output as \code{\link[=add_base.mcgf]{add_base.mcgf()}} or
\code{\link[=add_base.mcgf_rs]{add_base.mcgf_rs()}}.}
}
\value{
\code{x} with newly added attributes of the base model.
}
\description{
Add base model outputted from \code{\link[=fit_base]{fit_base()}} to an \code{mcgf} object.
}
\details{
After fitting the base model by \code{\link[=fit_base]{fit_base()}}, the results can be added to
\code{x} by \code{\link[=add_base]{add_base()}}. To supply the base model directly, use \code{\link{base<-}} to
add the base model; the value must contain \code{model}, \code{par_base}, \code{cor_base},
\code{lag}, and \code{horizon}.
}
\examples{
data(sim1)
sim1_mcgf <- mcgf(sim1$data, dists = sim1$dists)
sim1_mcgf <- add_acfs(sim1_mcgf, lag_max = 5)
sim1_mcgf <- add_ccfs(sim1_mcgf, lag_max = 5)

# Fit a pure spatial model
fit_spatial <- fit_base(
    sim1_mcgf,
    model = "spatial",
    lag = 5,
    par_init = c(c = 0.001, gamma = 0.5),
    par_fixed = c(nugget = 0)
)
# Fit a pure temporal model
fit_temporal <- fit_base(
    sim1_mcgf,
    model = "temporal",
    lag = 5,
    par_init = c(a = 0.3, alpha = 0.5)
)

# Store the fitted models to 'sim1_mcgf'
sim1_mcgf <-
    add_base(sim1_mcgf,
        fit_s = fit_spatial,
        fit_t = fit_temporal,
        sep = TRUE
    )

# Fit a separable model
fit_sep <- fit_base(
    sim1_mcgf,
    model = "sep",
    lag = 5,
    par_init = c(
        c = 0.001,
        gamma = 0.5,
        a = 0.3,
        alpha = 0.5
    ),
    par_fixed = c(nugget = 0)
)
# Store the newly fitted model, and keep the old fit
sim1_mcgf <- add_base(sim1_mcgf, fit_base = fit_sep, old = TRUE)
model(sim1_mcgf, model = "base", old = TRUE)
}
\seealso{
Other functions on fitting an mcgf: 
\code{\link{add_lagr.mcgf}()},
\code{\link{fit_base.mcgf}()},
\code{\link{fit_lagr.mcgf}()},
\code{\link{krige.mcgf}()},
\code{\link{krige_new.mcgf}()}
}
\concept{functions on fitting an mcgf}
