% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourmcd.R
\name{contourmcd}
\alias{contourmcd}
\title{Contour Plot of the Bivariate Cauchy Density}
\usage{
contourmcd(mu, Sigma,
                   xlim = c(mu[1] + c(-10, 10)*Sigma[1, 1]),
                   ylim = c(mu[2] + c(-10, 10)*Sigma[2, 2]),
                   zlim = NULL, npt = 30, nx = npt, ny = npt,
                   main = "Multivariate Cauchy density",
                   sub = NULL, nlevels = 10,
                   levels = pretty(zlim, nlevels), tol = 1e-6, ...)
}
\arguments{
\item{mu}{length 2 numeric vector.}

\item{Sigma}{symmetric, positive-definite square matrix of order 2. The scatter matrix.}

\item{xlim, ylim}{x-and y- limits.}

\item{zlim}{z- limits. If NULL, it is the range of the values of the density on the x and y values within \code{xlim} and \code{ylim}.}

\item{npt}{number of points for the discretisation.}

\item{nx, ny}{number of points for the discretisation among the x- and y- axes.}

\item{main, sub}{main and sub title, as for \code{\link{title}}.}

\item{nlevels, levels}{arguments to be passed to the \code{\link{contour}} function.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in Sigma, for the estimation of the density. see \code{\link{dmcd}}.}

\item{...}{additional arguments to \code{\link{plot.window}}, \code{\link{title}}, \code{\link{Axis}} and \code{\link{box}}, typically \link{graphical parameters} such as \code{cex.axis}.}
}
\value{
Returns invisibly the probability density function.
}
\description{
Draws the contour plot of the probability density of the multivariate Cauchy distribution with 2 variables
with location parameter \code{mu} and scatter matrix \code{Sigma}.
}
\examples{
mu <- c(1, 4)
Sigma <- matrix(c(0.8, 0.2, 0.2, 0.2), nrow = 2)
contourmcd(mu, Sigma)

}
\references{
N. Bouhlel, D. Rousseau, A Generic Formula and Some Special Cases for the Kullback–Leibler Divergence between Central Multivariate Cauchy Distributions.
Entropy, 24, 838, July 2022.
\doi{10.3390/e24060838}
}
\seealso{
\code{\link{dmcd}}: probability density of a multivariate Cauchy density

\code{\link{plotmcd}}: 3D plot of a bivariate Cauchy density.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
