% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notation.R
\name{switch_notation_byname}
\alias{switch_notation_byname}
\title{Change row and column name notation}
\usage{
switch_notation_byname(a, margin = c(1, 2), from, to, flip = FALSE)
}
\arguments{
\item{a}{A matrix or list of matrices whose row and/or column notation is to be changed.}

\item{margin}{\code{1} For rows, \code{2} for columns, or \code{c(1, 2)} for both rows and columns. Default is \code{c(1, 2)}.}

\item{from}{The \code{notation} to switch \emph{away from}.}

\item{to}{The \code{notation} to switch \emph{to}.}

\item{flip}{A boolean that tells whether to also flip the notation. Default is \code{FALSE}.}
}
\value{
Matrices with row and column names with switched notation, per arguments.
}
\description{
This function switches matrix row and/or column names from one type of notation to another
based on the \code{from} and \code{to} arguments.
Optionally, prefix and suffix can be \code{flip}ped.
}
\examples{
m <- matrix(c(1, 2, 
              3, 4), nrow = 2, ncol = 2, byrow = TRUE, 
            dimnames = list(c("b [a]", "d [c]"), c("f [e]", "h [g]"))) \%>\% 
  setrowtype("Products [Industries]") \%>\% setcoltype("Industries [Products]")
m
switch_notation_byname(m, from = RCLabels::bracket_notation, to = RCLabels::arrow_notation, 
                       flip = TRUE)
# Also works for lists.
# Note that margin must be specified as a list here.
switch_notation_byname(list(m, m), margin = list(c(1, 2)), 
                       from = RCLabels::bracket_notation, 
                       to = RCLabels::arrow_notation, flip = TRUE)
}
