% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{cumprod_byname}
\alias{cumprod_byname}
\title{Cumulative element-product that respects row and column names}
\usage{
cumprod_byname(a)
}
\arguments{
\item{a}{a number, list of numbers, matrix or list of matrices for which cumulative element product is desired}
}
\value{
a single number, list of numbers, a single matrix, or a list of matrices,
depending on the nature of \code{a}
}
\description{
Provides cumulative element-products along a list or column of a data frame.
If \code{a} is a single number, \code{a} is returned.
If \code{a} is a list of numbers, a list representing the cumulative product of the numbers is returned.
If \code{a} is a single matrix, \code{a} is returned.
If \code{a} is a list of matrices, a list representing the cumulative product
of the matrices is returned.
In this case, each entry in the returned list is product "by name,"
such that row and column names of the matrices are respected.
}
\details{
This function respects groups if \code{a} is a variable in a data frame.
}
\examples{
cumprod_byname(list(1, 2, 3, 4, 5))
m1 <- matrix(c(1), nrow = 1, ncol = 1, dimnames = list("r1", "c1")) \%>\%
  setrowtype("row") \%>\% setcoltype("col")
m2 <- matrix(c(2), nrow = 1, ncol = 1, dimnames = list("r2", "c2")) \%>\%
  setrowtype("row") \%>\% setcoltype("col")
m3 <- matrix(c(3), nrow = 1, ncol = 1, dimnames = list("r3", "c3")) \%>\%
  setrowtype("row") \%>\% setcoltype("col")
cumprod_byname(list(m1, m2, m3))
}
