% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.postestimation.R
\name{cei}
\alias{cei}
\title{Composite Equivalence Indices}
\usage{
cei(object, object2 = NULL, ...)
}
\arguments{
\item{object}{matrixpls estimation result object produced by the \code{\link{matrixpls}} function.}

\item{object2}{Another \code{matrixpls} object that \code{matrixpls} is
compared against.}

\item{...}{All other arguments are ignored.}
}
\value{
Composite equivalence indices as a vector
}
\description{
The \code{matrixpls} method for the generic function \code{cei} computes 
composite equivalence indices (CEI) for the \code{matrixpls} object. By
default, the composites are compared against unit-weighted composites.
}
\details{
Composite equivalence indices quantify if two sets of composites calculated
from the same data using different weight algorithms differ. Composites are 
matched by name and correlations for each pair are reported.
}
\examples{
# Load the Tenenhaus et al 2005 model and data from semPLS
library(semPLS)
data(ECSImobi)
data(mobi)

# Reflective and empty formative model
reflective<- ECSImobi$M
formative <- t(reflective)
formative[] <- 0

# Estimation using covariance matrix
model <- list(inner =  t(ECSImobi$D),
              reflective = reflective,
              formative = formative)


S <- cor(mobi)

matrixpls.ModeA <- matrixpls(S, model, innerEstim = innerEstim.centroid)
matrixpls.Fixed <- matrixpls(S, model, weightFun = weightFun.fixed)

cei(matrixpls.ModeA)
cei(matrixpls.ModeA, matrixpls.Fixed)
}
\seealso{
Other post-estimation functions: 
\code{\link{ave}()},
\code{\link{cr}()},
\code{\link{effects.matrixpls}()},
\code{\link{fitSummary}()},
\code{\link{fitted.matrixpls}()},
\code{\link{gof}()},
\code{\link{htmt}()},
\code{\link{loadings}()},
\code{\link{predict.matrixpls}()},
\code{\link{r2}()},
\code{\link{residuals.matrixpls}()}
}
\concept{post-estimation functions}
