% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.MPHstar.R
\name{fit,MPHstar-method}
\alias{fit,MPHstar-method}
\title{Fit method for mph class}
\usage{
\S4method{fit}{MPHstar}(
  x,
  y,
  weight = numeric(0),
  stepsEM = 1000,
  uni_epsilon = 1e-04,
  zero_tol = 1e-04,
  every = 100,
  plot = F,
  r = 1,
  replace = F
)
}
\arguments{
\item{x}{An object of class \linkS4class{MPHstar}.}

\item{y}{A matrix of marginal data.}

\item{weight}{A matrix of marginal weights.}

\item{stepsEM}{The number of EM steps to be performed, defaults to 1000.}

\item{uni_epsilon}{The epsilon parameter for the uniformization method, defaults to 1e-4.}

\item{zero_tol}{The smallest value that a reward can take (to avoid numerical instability), defaults to 1e-4.}

\item{every}{The number of iterations between likelihood display updates. The originating distribution is used, given that there is no explicit density.}

\item{plot}{Boolean that determines if the plot of the loglikelihood evolution is plotted, defaults to False.}

\item{r}{The sub-sampling proportion for stochastic EM, defaults to 1.}

\item{replace}{Boolean that determines if sub-sampling is done with replacement or not, defaults to False.}
}
\value{
An object of class \linkS4class{MPHstar}.
}
\description{
Fit method for mph class
}
\examples{
set.seed(123)
obj <- MPHstar(structure = "general")
data <- sim(obj, 100)
fit(obj, data, stepsEM = 20)
}
