% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bartlett.R
\name{bartlett}
\alias{bartlett}
\alias{row_bartlett}
\alias{col_bartlett}
\title{Bartlett test}
\usage{
row_bartlett(x, g)

col_bartlett(x, g)
}
\arguments{
\item{x}{numeric matrix.}

\item{g}{a vector specifying group membership for each observation of x.}
}
\value{
a data.frame where each row contains the results of the bartlett test
performed on the corresponding row/column of x.\cr\cr
Each row contains the following information (in order):\cr
1. obs.tot - total number of observations\cr
2. obs.groups - number of groups\cr
3. var.pooled - pooled variance estimate\cr
4. df - degrees of freedom\cr
5. statistic - chi-squared statistic\cr
6. pvalue - p-value
}
\description{
Performs the Bartlett's test of homogeneity of variances on each row/column
of the input matrix.
}
\details{
NA values are always ommited. If values are missing for a whole group - that
group is discarded. Groups with only one observation are also discarded.

\code{row_bartlett(x, g)} - Bartlet's test on rows.
\code{col_bartlett(x, g)} - Bartlet's test on columns.

Results should be the same as as running \code{bartlett.test(x, g)}
on every row (or column) of \code{x}.
}
\examples{
col_bartlett(iris[,1:4], iris$Species)
row_bartlett(t(iris[,1:4]), iris$Species)

}
\seealso{
\code{bartlett.test()}
}
\author{
Karolis Koncevičius
}
