## ----nomessages, echo = FALSE-------------------------------------------------
knitr::opts_chunk$set(
  warning = FALSE,
  message = FALSE
)
options(digits=4)
par(mar=c(5,4,1,1)+.1)

## ----setuprgl, echo=FALSE-----------------------------------------------------
library(rgl)
library(knitr)
knit_hooks$set(webgl = hook_webgl)

## -----------------------------------------------------------------------------
library(matlib)   # use the package

## -----------------------------------------------------------------------------
A <- matrix(c(1, 2, -1, 2), 2, 2)
b <- c(2,1)
showEqn(A, b)
c( R(A), R(cbind(A,b)) )          # show ranks
all.equal( R(A), R(cbind(A,b)) )  # consistent?


## ----echo=2-------------------------------------------------------------------
par(mar=c(4,4,0,0)+.1)
plotEqn(A,b)

## -----------------------------------------------------------------------------
Solve(A, b, fractions = TRUE)

## -----------------------------------------------------------------------------
A <- matrix(c(1,2,3, -1, 2, 1), 3, 2)
b <- c(2,1,3)
showEqn(A, b)
c( R(A), R(cbind(A,b)) )          # show ranks
all.equal( R(A), R(cbind(A,b)) )  # consistent?

Solve(A, b, fractions=TRUE)       # show solution 

## ----echo=2-------------------------------------------------------------------
par(mar=c(4,4,0,0)+.1)
plotEqn(A,b)

## -----------------------------------------------------------------------------
A <- matrix(c(1,2,3, -1, 2, 1), 3, 2)
b <- c(2,1,6)
showEqn(A, b)
c( R(A), R(cbind(A,b)) )          # show ranks
all.equal( R(A), R(cbind(A,b)) )  # consistent?

## -----------------------------------------------------------------------------
echelon(A, b)

## -----------------------------------------------------------------------------
Solve(A, b, fractions=TRUE)

## -----------------------------------------------------------------------------
x <- MASS::ginv(A) %*% b
x

## -----------------------------------------------------------------------------
par(mar=c(4,4,0,0)+.1)
plotEqn(A,b, xlim=c(-2, 4))
points(x[1], x[2], pch=15)

## -----------------------------------------------------------------------------
A <- matrix(c(2, 1, -1,
             -3, -1, 2,
             -2,  1, 2), 3, 3, byrow=TRUE)
colnames(A) <- paste0('x', 1:3)
b <- c(8, -11, -3)
showEqn(A, b)

## -----------------------------------------------------------------------------
c( R(A), R(cbind(A,b)) )          # show ranks
all.equal( R(A), R(cbind(A,b)) )  # consistent?

## -----------------------------------------------------------------------------
solve(A, b)
solve(A) %*% b
inv(A) %*% b

## -----------------------------------------------------------------------------
echelon(A, b)
echelon(A, b, verbose=TRUE, fractions=TRUE)

## ----plotEqn1, webgl=TRUE-----------------------------------------------------
plotEqn3d(A,b, xlim=c(0,4), ylim=c(0,4))

## -----------------------------------------------------------------------------
A <- matrix(c(1,  3, 1,
              1, -2, -2,
              2,  1, -1), 3, 3, byrow=TRUE)
colnames(A) <- paste0('x', 1:3)
b <- c(2, 3, 6)
showEqn(A, b)

## -----------------------------------------------------------------------------
c( R(A), R(cbind(A,b)) )          # show ranks
all.equal( R(A), R(cbind(A,b)) )  # consistent?

