% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regvec3d.R
\name{regvec3d}
\alias{regvec3d}
\alias{regvec3d.default}
\alias{regvec3d.formula}
\title{Vector space representation of a two-variable regression model}
\usage{
regvec3d(x1, ...)

\method{regvec3d}{formula}(formula, data = NULL, which = 1:2, name.x1,
  name.x2, name.y, name.e, name.y.hat, name.b1.x1, name.b2.x2, abbreviate = 0,
  ...)

\method{regvec3d}{default}(x1, x2, y, scale = FALSE, normalize = TRUE,
  name.x1 = deparse(substitute(x1)), name.x2 = deparse(substitute(x2)),
  name.y = deparse(substitute(y)), name.e = "residuals",
  name.y.hat = paste0(name.y, "hat"), name.b1.x1 = paste0("b1", name.x1),
  name.b2.x2 = paste0("b2", name.x2), name.y1.hat = paste0(name.y, "hat 1"),
  name.y2.hat = paste0(name.y, "hat 2"), ...)
}
\arguments{
\item{x1}{The generic argument or the first predictor passed to the default method}

\item{...}{Arguments passed to methods}

\item{formula}{A two-sided formula for the linear regression model. It must contain two quantitative predictors
(\code{x1} and \code{x2}) on the right-hand-side.  If further predictors are included, \code{y},
\code{x1} and \code{x2} are taken as residuals from the their linear fits on these variables.}

\item{data}{A data frame in which the variables in the model are found}

\item{which}{Indices of predictors variables in the model taken as \code{x1} and \code{x2}}

\item{name.x1}{Name for \code{x1} to be used in the result and plots. By default, this is taken as the
name of the \code{x1} variable in the \code{formula}, possibly abbreviated according to \code{abbreviate}.}

\item{name.x2}{Ditto for the name of \code{x2}}

\item{name.y}{Ditto for the name of \code{y}}

\item{name.e}{Name for the residual vector. Default: \code{"residuals"}}

\item{name.y.hat}{Name for the fitted vector}

\item{name.b1.x1}{Name for the vector corresponding to the partial coefficient of \code{x1}}

\item{name.b2.x2}{Name for the vector corresponding to the partial coefficient of \code{x2}}

\item{abbreviate}{An integer.  If \code{abbreviate >0}, the names of \code{x1}, \code{x2} and \code{y}
are abbreviated to this length before being combined with the other \code{name.*} arguments}

\item{x2}{second predictor variable in the model}

\item{y}{response variable in the model}

\item{scale}{logical; if \code{TRUE}, standardize each of \code{y}, \code{x1}, \code{x2} to standard scores}

\item{normalize}{logical; if \code{TRUE}, normalize each vector relative to the maximum length of all}

\item{name.y1.hat}{Name for the vector corresponding to the marginal coefficient of \code{x1}}

\item{name.y2.hat}{Name for the vector corresponding to the marginal coefficient of \code{x2}}
}
\value{
An object of class \dQuote{regvec3d}, containing the following components
            \item{model}{The \dQuote{lm} object corresponding to \code{lm(y ~ x1 + x2)}.}
            \item{vectors}{A 9 x 3 matrix, whose rows correspond to the variables in the model,
               the residual vector, the fitted vector, the partial fits for \code{x1}, \code{x2},
               and the marginal fits of \code{y} on \code{x1} and \code{x2}.
               The columns effectively represent \code{x1}, \code{x2}, and \code{y}, but
               are named \code{"x"}, \code{"y"} and \code{"z"}.}
}
\description{
\code{regvec3d} calculates the 3D vectors that represent the projection of a two-variable multiple
regression model from n-D \emph{observation} space into the 3D mean-deviation \emph{variable} space that they span, thus
showing the regression of \code{y} on \code{x1} and \code{x2} in the model \code{lm(y ~ x1 + x2)}.
The result can be used to draw 2D and 3D vector diagrams accurately reflecting the partial and marginal
relations of \code{y} to \code{x1} and \code{x2} as vectors in this representation.
}
\details{
If additional variables are included in the model, e.g., \code{lm(y ~ x1 + x2 + x3 + ...)}, then
\code{y}, \code{x1} and \code{x2} are all taken as \emph{residuals} from their separate linear fits
on \code{x3 + ...}, thus showing their partial relations net of (or adjusting for) these additional predictors.

A 3D diagram shows the vector \code{y} and the plane formed by the predictors,
\code{x1} and \code{x2}, where all variables are represented in deviation form, so that
the intercept need not be included.

A 2D diagram, using the first two columns of the result, can be used to show the projection
of the space in the \code{x1}, \code{x2} plane.

In these views, the ANOVA representation of the various sums of squares for the regression
predictors appears as the lengths of the various vectors.  For example, the error sum of
squares is the squared length of the \code{e} vector, and the regression sum of squares is
the squared length of the \code{yhat} vector.

The drawing functions \code{\link{vectors}} and \code{link{vectors3d}} used by the \code{\link{plot.regvec3d}} method only work
reasonably well if the variables are shown on commensurate scales, i.e., with
either \code{scale=TRUE} or \code{normalize=TRUE}.
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: Formula method for regvec3d

\item \code{default}: Default method for regvec3d
}}
\examples{
library(rgl)
therapy.vec <- regvec3d(therapy ~ perstest + IE, data=therapy)
therapy.vec
plot(therapy.vec)
plot(therapy.vec, dimension="2")
}
\references{
Fox, J. (2016). \emph{Applied Regression Analysis and Generalized Linear Models}, 3rd ed., Sage, Chapter 10.
}
\seealso{
\code{\link{plot.regvec3d}}

Other vector diagrams: \code{\link{Proj}},
  \code{\link{arc}}, \code{\link{arrows3d}},
  \code{\link{corner}}, \code{\link{plot.regvec3d}},
  \code{\link{point_on_line}}, \code{\link{vectors3d}},
  \code{\link{vectors}}
}

