/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.automata.fast_costregular;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBool;
import choco.kernel.model.constraints.automaton.FA.CostAutomaton;
import choco.kernel.model.constraints.automaton.FA.IAutomaton;
import choco.kernel.model.constraints.automaton.FA.ICostAutomaton;
import choco.kernel.model.constraints.automaton.FA.utils.Bounds;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.global.automata.common.StoredIndexedBipartiteSetWithOffset;
import choco.kernel.solver.constraints.global.automata.fast_costregular.structure.Arc;
import choco.kernel.solver.constraints.global.automata.fast_costregular.structure.Node;
import choco.kernel.solver.constraints.global.automata.fast_costregular.structure.StoredValuedDirectedMultiGraph;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntStack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.graph.DirectedMultigraph;

public class CostRegular
extends AbstractLargeIntSConstraint {
    IntDomainVar[] vs;
    IntDomainVar z;
    StoredValuedDirectedMultiGraph graph;
    TIntStack toRemove;
    IStateBool boundChange;
    int lastWorld = -1;
    int lastNbOfBacktracks = -1;
    int lastNbOfRestarts = -1;
    protected final IEnvironment environment;
    Solver solver;
    ICostAutomaton pi;
    DirectedMultigraph<Node, Arc> originalGraph;
    Node source;

    private CostRegular(IntDomainVar[] vars, Solver s) {
        super(ConstraintEvent.CUBIC, vars);
        this.environment = s.getEnvironment();
        this.solver = s;
        this.vs = new IntDomainVar[vars.length - 1];
        System.arraycopy(vars, 0, this.vs, 0, this.vs.length);
        this.z = vars[vars.length - 1];
        this.toRemove = new TIntStack();
        this.boundChange = this.environment.makeBool(false);
    }

    public CostRegular(IntDomainVar[] vars, IAutomaton pi, int[][][] costs, Solver s) {
        this(vars, s);
        this.pi = CostAutomaton.makeSingleResource(pi, costs, this.z.getInf(), this.z.getSup());
    }

    public CostRegular(IntDomainVar[] vars, IAutomaton pi, int[][] costs, Solver s) {
        this(vars, s);
        this.pi = CostAutomaton.makeSingleResource(pi, costs, this.z.getInf(), this.z.getSup());
    }

    public CostRegular(IntDomainVar[] vars, ICostAutomaton pi, Solver s) {
        this(vars, s);
        this.pi = pi;
    }

    public CostRegular(IntDomainVar[] vars, DirectedMultigraph<Node, Arc> graph, Node source, Solver s) {
        this(vars, s);
        this.originalGraph = graph;
        this.source = source;
    }

    public void initGraph(DirectedMultigraph<Node, Arc> graph, Node source) {
        int[] offsets = new int[this.vs.length];
        int[] sizes = new int[this.vs.length];
        int[] starts = new int[this.vs.length];
        int totalSizes = 0;
        starts[0] = 0;
        for (int i = 0; i < this.vs.length; ++i) {
            offsets[i] = this.vs[i].getInf();
            sizes[i] = this.vs[i].getSup() - this.vs[i].getInf() + 1;
            if (i > 0) {
                starts[i] = sizes[i - 1] + starts[i - 1];
            }
            totalSizes += sizes[i];
        }
        TIntArrayList[] layers = new TIntArrayList[this.vs.length + 1];
        for (int i = 0; i < layers.length; ++i) {
            layers[i] = new TIntArrayList();
        }
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        source.layer = 0;
        queue.add(source);
        int nid = 0;
        int aid = 0;
        while (!queue.isEmpty()) {
            Node n = (Node)queue.remove();
            n.id = nid++;
            layers[n.layer].add(n.id);
            Set tmp = graph.outgoingEdgesOf(n);
            for (Arc a : tmp) {
                a.id = aid++;
                Node next = (Node)graph.getEdgeTarget(a);
                next.layer = n.layer + 1;
                queue.add(next);
            }
        }
        int[][] lays = new int[layers.length][];
        for (int i = 0; i < lays.length; ++i) {
            lays[i] = layers[i].toNativeArray();
        }
        this.graph = new StoredValuedDirectedMultiGraph(this.solver.getEnvironment(), this, graph, lays, starts, offsets, totalSizes);
    }

    public void initGraph(ICostAutomaton pi) throws ContradictionException {
        Node o;
        int k;
        TIntIterator layerIter;
        int j;
        DisposableIntIterator varIter;
        int i;
        int aid = 0;
        int nid = 0;
        int[] offsets = new int[this.vs.length];
        int[] sizes = new int[this.vs.length];
        int[] starts = new int[this.vs.length];
        int totalSizes = 0;
        starts[0] = 0;
        for (int i2 = 0; i2 < this.vs.length; ++i2) {
            offsets[i2] = this.vs[i2].getInf();
            sizes[i2] = this.vs[i2].getSup() - this.vs[i2].getInf() + 1;
            if (i2 > 0) {
                starts[i2] = sizes[i2 - 1] + starts[i2 - 1];
            }
            totalSizes += sizes[i2];
        }
        int n = this.vs.length;
        DirectedMultigraph<Node, Arc> graph = new DirectedMultigraph<Node, Arc>(new Arc.ArcFacroty());
        ArrayList tmp = new ArrayList(totalSizes);
        for (i = 0; i < totalSizes; ++i) {
            tmp.add(new HashSet());
        }
        ArrayList<TIntHashSet> layer = new ArrayList<TIntHashSet>();
        TIntHashSet[] tmpQ = new TIntHashSet[totalSizes];
        for (i = 0; i <= n; ++i) {
            layer.add(new TIntHashSet());
        }
        ((TIntHashSet)layer.get(0)).add(pi.getInitialState());
        TIntHashSet succ = new TIntHashSet();
        for (i = 0; i < n; ++i) {
            varIter = this.vs[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                layerIter = ((TIntHashSet)layer.get(i)).iterator();
                while (layerIter.hasNext()) {
                    k = layerIter.next();
                    succ.clear();
                    pi.delta(k, j, succ);
                    if (succ.isEmpty()) continue;
                    TIntIterator it = succ.iterator();
                    while (it.hasNext()) {
                        ((TIntHashSet)layer.get(i + 1)).add(it.next());
                    }
                    int idx = starts[i] + j - offsets[i];
                    if (tmpQ[idx] == null) {
                        tmpQ[idx] = new TIntHashSet();
                    }
                    tmpQ[idx].add(k);
                }
            }
            varIter.dispose();
        }
        layerIter = ((TIntHashSet)layer.get(n)).iterator();
        while (layerIter.hasNext()) {
            k = layerIter.next();
            if (pi.isFinal(k)) continue;
            layerIter.remove();
        }
        int nbNodes = pi.getNbStates();
        BitSet mark = new BitSet(nbNodes);
        Node[] in = new Node[pi.getNbStates() * (n + 1)];
        Node tink = new Node(pi.getNbStates() + 1, n + 1, nid++);
        graph.addVertex(tink);
        for (i = n - 1; i >= 0; --i) {
            mark.clear(0, nbNodes);
            varIter = this.vs[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                int idx = starts[i] + j - offsets[i];
                TIntHashSet l = tmpQ[idx];
                if (l == null) continue;
                TIntIterator qijIter = l.iterator();
                while (qijIter.hasNext()) {
                    k = qijIter.next();
                    succ.clear();
                    pi.delta(k, j, succ);
                    TIntIterator it = succ.iterator();
                    boolean added = false;
                    while (it.hasNext()) {
                        Node b;
                        int qn = it.next();
                        if (!((TIntHashSet)layer.get(i + 1)).contains(qn)) continue;
                        added = true;
                        Node a = in[i * pi.getNbStates() + k];
                        if (a == null) {
                            in[i * pi.getNbStates() + k] = a = new Node(k, i, nid++);
                            graph.addVertex(a);
                        }
                        if ((b = in[(i + 1) * pi.getNbStates() + qn]) == null) {
                            in[(i + 1) * pi.getNbStates() + qn] = b = new Node(qn, i + 1, nid++);
                            graph.addVertex(b);
                        }
                        Arc arc = new Arc(a, b, j, aid++, pi.getCostByState(i, j, a.state));
                        graph.addEdge(a, b, arc);
                        ((HashSet)tmp.get(idx)).add(arc);
                        mark.set(k);
                    }
                    if (added) continue;
                    qijIter.remove();
                }
            }
            varIter.dispose();
            layerIter = ((TIntHashSet)layer.get(i)).iterator();
            while (layerIter.hasNext()) {
                if (mark.get(layerIter.next())) continue;
                layerIter.remove();
            }
        }
        TIntHashSet th = new TIntHashSet();
        int[][] intLayer = new int[n + 2][];
        for (k = 0; k < pi.getNbStates(); ++k) {
            o = in[n * pi.getNbStates() + k];
            if (o == null) continue;
            Arc a = new Arc(o, tink, 0, aid++, 0.0);
            graph.addEdge(o, tink, a);
        }
        for (i = 0; i <= n; ++i) {
            th.clear();
            for (k = 0; k < pi.getNbStates(); ++k) {
                o = in[i * pi.getNbStates() + k];
                if (o == null) continue;
                th.add(o.id);
            }
            intLayer[i] = th.toArray();
        }
        intLayer[n + 1] = new int[]{tink.id};
        if (intLayer[0].length > 0) {
            this.graph = new StoredValuedDirectedMultiGraph(this.solver.getEnvironment(), this, graph, intLayer, starts, offsets, totalSizes);
        } else {
            this.fail();
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.checkBounds();
        if (this.pi != null) {
            this.initGraph(this.pi);
        } else if (this.originalGraph != null) {
            this.initGraph(this.originalGraph, this.source);
        }
        this.prefilter();
        this.pi = null;
        this.originalGraph = null;
        this.source = null;
    }

    private void checkBounds() throws ContradictionException {
        Bounds bounds = this.pi.getCounters().get(0).bounds();
        this.z.updateInf(bounds.min.value, this, false);
        this.z.updateSup(bounds.max.value, this, false);
    }

    public void prefilter() throws ContradictionException {
        int id;
        double zinf = this.graph.GNodes.spft.get(this.graph.sourceIndex);
        double zsup = this.graph.GNodes.lpfs.get(this.graph.tinkIndex);
        this.z.updateInf((int)Math.ceil(zinf), this, false);
        this.z.updateSup((int)Math.floor(zsup), this, false);
        DisposableIntIterator it = this.graph.inGraph.getIterator();
        while (it.hasNext()) {
            id = it.next();
            int orig = this.graph.GArcs.origs[id];
            int dest = this.graph.GArcs.dests[id];
            double acost = this.graph.GArcs.costs[id];
            double spfs = this.graph.GNodes.spfs.get(orig);
            double lpfs = this.graph.GNodes.lpfs.get(orig);
            double spft = this.graph.GNodes.spft.get(dest);
            double lpft = this.graph.GNodes.lpft.get(dest);
            if (!(spfs + spft + acost > (double)this.z.getSup()) && !(lpfs + lpft + acost < (double)this.z.getInf()) || this.graph.isInStack(id)) continue;
            this.graph.setInStack(id);
            this.toRemove.push(id);
        }
        it.dispose();
        try {
            while (true) {
                if (this.toRemove.size() > 0) {
                    id = this.toRemove.pop();
                    this.graph.removeArc(id, this.toRemove);
                    continue;
                }
                while (this.graph.toUpdateLeft.size() > 0) {
                    this.graph.updateLeft(this.graph.toUpdateLeft.pop(), this.toRemove);
                }
                while (this.graph.toUpdateRight.size() > 0) {
                    this.graph.updateRight(this.graph.toUpdateRight.pop(), this.toRemove);
                }
                if (this.toRemove.size() <= 0) break;
            }
        }
        catch (ContradictionException e) {
            this.toRemove.reset();
            this.graph.inStack.clear();
            this.graph.toUpdateLeft.reset();
            this.graph.toUpdateRight.reset();
            throw e;
        }
    }

    protected void checkWorld() {
        int currentworld = this.environment.getWorldIndex();
        int currentbt = this.solver.getBackTrackCount();
        int currentrestart = this.solver.getRestartCount();
        if (currentworld < this.lastWorld || currentbt != this.lastNbOfBacktracks || currentrestart > this.lastNbOfRestarts) {
            this.toRemove.reset();
            this.graph.inStack.clear();
            this.graph.toUpdateLeft.reset();
            this.graph.toUpdateRight.reset();
        }
        this.lastWorld = currentworld;
        this.lastNbOfBacktracks = currentbt;
        this.lastNbOfRestarts = currentrestart;
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator it2) throws ContradictionException {
        this.checkWorld();
        boolean mod = false;
        while (it2.hasNext()) {
            int val = it2.next();
            StoredIndexedBipartiteSetWithOffset sup = this.graph.getSupport(idx, val);
            if (sup == null) continue;
            DisposableIntIterator it = sup.getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                if (this.graph.isInStack(arcId)) continue;
                this.graph.setInStack(arcId);
                this.toRemove.push(arcId);
                mod = true;
            }
            it.dispose();
        }
        it2.dispose();
        if (mod) {
            this.constAwake(false);
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.checkWorld();
        this.boundChange.set(true);
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.checkWorld();
        this.boundChange.set(true);
        this.constAwake(false);
    }

    @Override
    public void awakeOnInst(int idx) {
        System.err.println("CALLED INST");
    }

    @Override
    public void awakeOnBounds(int idx) {
        System.err.println("CALLED BOUNDS");
    }

    @Override
    public void awakeOnRem(int idx, int val) {
        System.err.println("CALLED REM");
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.boundChange.get()) {
            this.boundChange.set(false);
            DisposableIntIterator it = this.graph.inGraph.getIterator();
            while (it.hasNext()) {
                int id = it.next();
                int orig = this.graph.GArcs.origs[id];
                int dest = this.graph.GArcs.dests[id];
                double acost = this.graph.GArcs.costs[id];
                double lpfs = this.graph.GNodes.lpfs.get(orig);
                double lpft = this.graph.GNodes.lpft.get(dest);
                double spfs = this.graph.GNodes.spfs.get(orig);
                double spft = this.graph.GNodes.spft.get(dest);
                if (!(lpfs + lpft + acost < (double)this.z.getInf()) && !(spfs + spft + acost > (double)this.z.getSup()) || this.graph.isInStack(id)) continue;
                this.graph.setInStack(id);
                this.toRemove.push(id);
            }
            it.dispose();
        }
        while (true) {
            if (this.toRemove.size() > 0) {
                int id = this.toRemove.pop();
                this.graph.removeArc(id, this.toRemove);
                continue;
            }
            while (this.graph.toUpdateLeft.size() > 0) {
                this.graph.updateLeft(this.graph.toUpdateLeft.pop(), this.toRemove);
            }
            while (this.graph.toUpdateRight.size() > 0) {
                this.graph.updateRight(this.graph.toUpdateRight.pop(), this.toRemove);
            }
            if (this.toRemove.size() <= 0) break;
        }
        double zinf = this.graph.GNodes.spft.get(this.graph.sourceIndex);
        double zsup = this.graph.GNodes.lpfs.get(this.graph.tinkIndex);
        this.z.updateInf((int)Math.ceil(zinf), this, false);
        this.z.updateSup((int)Math.floor(zsup), this, false);
    }

    @Override
    public final int getFilteredEventMask(int idx) {
        return idx < this.vs.length ? 4 : 3;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int first = this.graph.sourceIndex;
        double cost = 0.0;
        for (int i = 0; i < tuple.length - 1; ++i) {
            boolean found = false;
            StoredIndexedBipartiteSetWithOffset bs = this.graph.GNodes.outArcs[first];
            DisposableIntIterator it = bs.getIterator();
            while (!found && it.hasNext()) {
                int idx = it.next();
                if (this.graph.GArcs.values[idx] != tuple[i]) continue;
                found = true;
                first = this.graph.GArcs.dests[idx];
                cost += this.graph.GArcs.costs[idx];
            }
            if (found) continue;
            return false;
        }
        int intCost = tuple[tuple.length - 1];
        return cost == (double)intCost;
    }
}

