/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables.scheduling;

import choco.kernel.common.IIndex;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.structure.APartiallyStoredCstrList;
import choco.kernel.memory.structure.Couple;
import choco.kernel.memory.structure.PartiallyStoredIntVector;
import choco.kernel.memory.structure.PartiallyStoredTaskCstrList;
import choco.kernel.memory.structure.PartiallyStoredVector;
import choco.kernel.model.variables.scheduling.ITaskVariable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.Extension;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.global.scheduling.AbstractTaskSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.propagation.event.TaskVarEvent;
import choco.kernel.solver.propagation.event.VarEvent;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.AbstractTask;

public final class TaskVar<C extends AbstractSConstraint>
extends AbstractTask
implements Var,
ITaskVariable<IntDomainVar>,
IIndex {
    private final int id;
    private final String name;
    protected final IntDomainVar start;
    protected final IntDomainVar end;
    protected final IntDomainVar duration;
    private long index;
    protected APartiallyStoredCstrList<C> constraints;
    protected final VarEvent<? extends Var> event;
    private final PropagationEngine propagationEngine;

    public TaskVar(Solver solver, int id, String name, IntDomainVar start, IntDomainVar end, IntDomainVar duration) {
        this.id = id;
        this.name = name;
        this.start = start;
        this.end = end;
        this.duration = duration;
        this.constraints = new PartiallyStoredTaskCstrList(solver.getEnvironment());
        this.index = solver.getIndexfactory().getIndex();
        this.event = new TaskVarEvent(this);
        this.propagationEngine = solver.getPropagationEngine();
    }

    @Override
    public final boolean isPreemptionAllowed() {
        return false;
    }

    @Override
    public final int getID() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public int getPriority() {
        return this.constraints.getPriority();
    }

    @Override
    public final IntDomainVar start() {
        return this.start;
    }

    @Override
    public final IntDomainVar end() {
        return this.end;
    }

    @Override
    public final IntDomainVar duration() {
        return this.duration;
    }

    @Override
    public int getECT() {
        return this.end.getInf();
    }

    @Override
    public int getEST() {
        return this.start.getInf();
    }

    @Override
    public int getLCT() {
        return this.end.getSup();
    }

    @Override
    public int getLST() {
        return this.start.getSup();
    }

    @Override
    public int getMaxDuration() {
        return this.duration.getSup();
    }

    @Override
    public int getMinDuration() {
        return this.duration.getInf();
    }

    @Override
    public boolean hasConstantDuration() {
        return this.duration.isInstantiated();
    }

    @Override
    public boolean isScheduled() {
        return this.isInstantiated();
    }

    @Override
    public VarEvent<? extends Var> getEvent() {
        return this.event;
    }

    @Override
    public SConstraint getConstraint(int i) {
        return this.constraints.getConstraint(i);
    }

    @Override
    public int getNbConstraints() {
        return this.constraints.getNbConstraints();
    }

    public PartiallyStoredVector<C> getConstraintVector() {
        return this.constraints.getConstraintVector();
    }

    @Override
    public PartiallyStoredIntVector getIndexVector() {
        return null;
    }

    @Override
    public int getVarIndex(int constraintIndex) {
        return -1;
    }

    public void eraseConstraint(SConstraint<? extends Var> c) {
        this.constraints.eraseConstraint(c);
    }

    @Override
    public int addConstraint(SConstraint c, int varIdx, boolean dynamicAddition) {
        return this.constraints.addConstraint(c, varIdx, dynamicAddition);
    }

    @Override
    public DisposableIterator<SConstraint> getConstraintsIterator() {
        return this.constraints.getConstraintsIterator();
    }

    public final DisposableIterator<Couple<C>> getActiveConstraints(C cstrCause) {
        return ((PartiallyStoredTaskCstrList)this.constraints).getActiveConstraint(cstrCause);
    }

    @Override
    public boolean isInstantiated() {
        return this.start.isInstantiated() && this.end.isInstantiated() && this.duration.isInstantiated();
    }

    public final void updateCompulsoryPart(SConstraint cause) throws ContradictionException {
        do {
            boolean fixPoint = false;
            fixPoint |= this.start.updateInf(this.end.getInf() - this.duration.getSup(), cause, false);
            fixPoint |= this.start.updateSup(this.end.getSup() - this.duration.getInf(), cause, false);
            fixPoint |= this.end.updateInf(this.start.getInf() + this.duration.getInf(), cause, false);
            fixPoint |= this.end.updateSup(this.start.getSup() + this.duration.getSup(), cause, false);
            fixPoint |= this.duration.updateInf(this.end.getInf() - this.start.getSup(), cause, false);
        } while (fixPoint |= this.duration.updateSup(this.end.getSup() - this.start.getInf(), cause, false));
    }

    public void updateHypotheticalDomain(int idx, SConstraint constraint, boolean forceAwake) {
        this.propagationEngine.postEvent(this, 0, constraint, forceAwake);
    }

    @Override
    public Extension getExtension(int extensionNumber) {
        return null;
    }

    @Override
    public void addExtension(int extensionNumber) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public final boolean detectOrPostConsistencyConstraint(Solver solver) {
        DisposableIterator<SConstraint> iter = this.getConstraintsIterator();
        while (iter.hasNext()) {
            SConstraint c = (SConstraint)iter.next();
            if (!(c instanceof AbstractTaskSConstraint) || !((AbstractTaskSConstraint)c).isTaskConsistencyEnforced()) continue;
            return true;
        }
        iter.dispose();
        this.postConsistencyConstraint(solver);
        return false;
    }

    public final void postConsistencyConstraint(Solver solver) {
        if (this.duration().isInstantiatedTo(0) && !this.start().equals(this.end())) {
            solver.post(solver.eq((IntExp)this.start(), (IntExp)this.end()));
        } else {
            solver.post(solver.eq(solver.plus((IntExp)this.start(), (IntExp)this.duration()), (IntExp)this.end()));
        }
    }

    public final void postHorizonConstraint(Solver solver, int horizon) {
        if (this.getLCT() > horizon) {
            solver.post(solver.leq((IntExp)this.end(), horizon));
        }
    }
}

