% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_2C.R
\name{match_2C}
\alias{match_2C}
\title{Optimal Matching with Two Criteria.}
\usage{
match_2C(
  Z,
  X,
  propensity,
  dataset,
  method = "maha",
  exact = NULL,
  caliper_left = 1,
  caliper_right = 1,
  k_left = NULL,
  k_right = NULL,
  fb_var = NULL,
  controls = 1,
  include = NULL
)
}
\arguments{
\item{Z}{A length-n vector of treatment indicator.}

\item{X}{A n-by-p matrix of covariates with column names.}

\item{propensity}{A vector of estimated propensity score (length(propensity) = length(Z)).}

\item{dataset}{Dataset to be matched.}

\item{method}{Method used to compute treated-control distance on the left. The default is the Mahalanobis distance.}

\item{exact}{A vector of strings indicating which variables need to be exactly matched.}

\item{caliper_left}{Size of caliper on the left network.}

\item{caliper_right}{Size of caliper on the right network.}

\item{k_left}{Connect each treated to k_left controls closest in the propensity score in the left network.}

\item{k_right}{Connect each treated to k_right controls closest in the propensity score in the right network.}

\item{fb_var}{A vector giving names of variables in matrix X to be finely balanced.}

\item{controls}{Number of controls matched to each treated. Default is 1.}

\item{include}{A binary vector indicating which controls must be included (length(include) = sum(1-Z)).}
}
\value{
This function returns a list of three objects including the feasibility
of the matching problem and the matched controls organized in different formats.
See the documentation of the function construct_outcome or the vignette for more
details.
}
\description{
This function performs an optimal statistical matching that sequentially balances the nominal levels
(near-fine balance), the marginal distribution of the propensity score, and the total
within-matched-pair Mahalanobis distance.
}
\examples{

# We first prepare the input X, Z, propensity score

attach(dt_Rouse)
X = cbind(female,black,bytest,dadeduc,momeduc,fincome)
Z = IV
propensity = glm(IV~female+black+bytest+dadeduc+momeduc+fincome,
                family=binomial)$fitted.values
detach(dt_Rouse)

matching_output_double_calipers = match_2C(Z = Z, X = X,
propensity = propensity,
caliper_left = 0.05, caliper_right = 0.05,
k_left = 100, k_right = 100,
dataset = dt_Rouse)


# Please refer to the vignette for many more examples.

}
