% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{maskRanger}
\alias{maskRanger}
\title{Make a matrix of modeling decisions to be used to specify clipping rules}
\usage{
maskRanger(
  potentialDist,
  initialDist = NULL,
  maskLayers,
  logicString,
  method = "mask"
)
}
\arguments{
\item{potentialDist}{A raster stack of binary or continuous values. Supplying more than one layer will be interepreted as different time periods. Layers should follow the naming convention `Y2000`, `Y2001`, etc. Must have same extent and resolution as maskLayers.}

\item{initialDist}{A raster showing a previously created optimally tuned SDM. Must have same extent and resolution as maskLayers.}

\item{maskLayers}{A single raster or a raster stack. If a single raster, the same mask will be applied to each layer of `potentialDist`. If a stack it must have the same number of layers as potentialDist, and each layer corresponds to a different time period. Must have same extent and resolution as initialDist.}

\item{logicString}{a character indicating the logical conditions to use for masking.}

\item{method}{A list of strings defining methods to be used, in the same order as `rsList`. If a single value is provided it will be applied to all rasters in `rsList`. Options currently include only `mask` to mask cells with values outside the bounds.}
}
\value{
a raster stack
}
\description{
Performs data driven masking of potential species distributions.
}
\details{
See Examples.
}
\note{
To apply multiple masks, e.g., elevation and forest cover, use separate calls to maskRS.
}
\examples{
# Multiple Expert Maps
# Generate random polygon
env1 <- raster::raster(nrows=108, ncols=21, xmn=0, xmx=10)
env2 <- raster::raster(nrows=108, ncols=21, xmn=0, xmx=10)
env3 <- raster::raster(nrows=108, ncols=21, xmn=0, xmx=10)
raster::values(env1)<- sort(runif(n = (108*21)))  
raster::values(env2)<- runif(n = (108*21))
raster::values(env3)<- runif(n = (108*21))
sdm <- raster::raster(nrows=108, ncols=21, xmn=0, xmx=10)
raster::values(sdm)<- sort(runif(n = (108*21)))  
coords <- dismo::randomPoints(sdm, 3)
polyg <- sp::Polygon(coords)
polyg <- sp::SpatialPolygons(list(sp::Polygons(list(polyg), ID = "a")))
expertRaster <- raster::rasterize(polyg, sdm)
maskStack <-raster:: stack(env1, env2, env3)
names(maskStack) <- c("env1", "env2", "env3")
# Get list of tolerances for environmental data
env1Vals <- quantile(raster::values(env1), prob = c(0, 0.025, 0.25, 0.5, 0.75, 0.975, 1), 
                     na.rm = TRUE)
env2Vals <- quantile(raster::values(env2), prob = c(0, 0.025, 0.25, 0.5, 0.75, 0.975, 1), 
                     na.rm = TRUE)
env3Vals <- quantile(raster::values(env3), prob = c(0, 0.025, 0.25, 0.5, 0.75, 0.975, 1), 
                     na.rm = TRUE)
maskBounds <- data.frame(rbind(cbind(env1Vals[[3]], env1Vals[[5]]), 
                               cbind(env2Vals[[3]], env2Vals[[5]]),
                               cbind(env3Vals[[3]], env3Vals[[5]])))
maskBounds <- cbind(names(maskStack), maskBounds)
colnames(maskBounds) <- c("Layer", "min", "max")
# mask range by these tolerance masks
realized <- lotsOfMasks(expertRaster, maskStack, maskBounds)
}
\author{
Cory Merow <cory.merow@gmail.com>,
}
