% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/WeekSummary.R
\name{WeekSummary}
\alias{WeekSummary}
\title{A report of your website performance during the past 7 days}
\usage{
WeekSummary(metrics, table.id, export = FALSE)
}
\arguments{
\item{metrics}{A list of comma-separated metrics, such as \code{ga:metrics}.}

\item{table.id}{The unique table ID of the form ga:XXXX, where XXXX is the
Analytics view (profile) ID for which the query will retrieve the data.}

\item{export}{If the export option is set as "TRUE", both raw data &
graphics will be exported in the current working directory. Otherwise,
R will only print raw data and display a visualization of the week summary.}
}
\description{
\code{WeekSummary} is a quick way to check how your website
  performed during the past 7 days, compared to your past scores.
}
\note{
The triangles are representing the results of the past 7 days.
  Their color may vary according to the mean (green is > mean, red is < mean).
  The mean is represented by the letter \code{m}.
}
\examples{
\dontrun{
WeekSummary(metrics = "ga:sessions", table.id = "ga:XXXXXXX", export = FALSE)}
}

