% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold.R
\name{plot_folds}
\alias{plot_folds}
\title{plot folds}
\usage{
plot_folds(data, folds, colors, ...)
}
\arguments{
\item{data}{Matrix or dataframe. Data for which the folds where created. The
first two columns should represent the longitude and latitude (or x,y
coordinates).}

\item{folds}{Numeric vector with group assignments from e.g.
\code{\link{kfold_disc}}, \code{\link{kfold_grid}} or
\code{\link[dismo]{kfold}}.}

\item{colors}{Colors to use for the different folds}

\item{...}{Arguments to be passed to the plot function.}
}
\description{
\code{plot_folds} makes a rudimentary plot of the data and the folds created
with e.g. \code{\link{kfold_disc}} or \code{\link[dismo]{kfold}}.
}
\examples{
set.seed(42)
lonlat_data <- cbind(runif(11, -180, 180), runif(11, -90, 90))
folds <- kfold_disc(lonlat_data, k = 5)
plot_folds(lonlat_data, folds)

}
\seealso{
\code{\link{kfold_disc}}, \code{\link{kfold_grid}},
  \code{\link[dismo]{kfold}}
}

