% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanLengthCommunity.R
\name{meanLengthCommunity}
\alias{meanLengthCommunity}
\title{Calculates the Mean Length of the Community weighted by biomass or
 abundance}
\usage{
meanLengthCommunity(X_length, metric, years)
}
\arguments{
\item{X_length}{A dataframe of fishery independent data derived from research
vessel survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, \code{LENGTH}, and \code{BIOMASS}. \code{YEAR} indicates the
year the observation was recorded, \code{ID} is an area code indicating
where the observation was recorded, and \code{SPECIES} is a numeric code
indicating the species sampled. \code{LENGTH} is the length class (cm) and
\code{BIOMASS} is the corresponding abundance at length (stratified and
corrected for catchability as required). Species for which there are no
length data should be assigned \code{LENGTH = -99}. These observations are
removed by the function.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate indicator.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with 3 columns. \code{ID}, \code{YEAR}, and
 \code{MeanLength_metric}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 value is assigned \code{NA}.
}
\description{
This function calculates the Mean Length of the Community
 weighted by biomass or abundance for \eqn{j} areas and \eqn{i} years.
}
\details{
\deqn{MeanLength = \Sigma(Length_m * metric_i)/\Sigma metric_j} where
 \eqn{Length_m} is the length (cm) of an individual in size class \eqn{m},
 \eqn{metric_i} is the biomass or abundance of species \eqn{i} and
 \eqn{metric_j} is the total biomass or abundance of the community (Shin et
 al., 2010).
}
\examples{
data(X_length)
# Weighted by abundance
meanLengthCommunity(X_length, metric = "ABUNDANCE", years = c(2014:2019))
# Weighted by biomass
meanLengthCommunity(X_length, metric = "BIOMASS", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Shin, YJ, Shannon LJ, Bundy A, Coll M, Aydin K, Bez N, Blanchard JL, Borges,
 MF, Diallo I, Diaz E, Heymans JJ, Hill L, Johannesen E, Jouffre D, Kifani S,
 Labrosse P, Link JS, Mackinson S, Masski H, Möllmann C, Neira S, Ojaveer H,
 Abdallahi KM, Perry I, Thiao D, Yemane D, and Cury PM. 2010. Using
 indicators for evaluating, comparing and communicating the ecological status
 of exploited marine ecosystems. Part 2: Setting the scene. ICES Journal of
 Marine Science, 67: 692-716
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{structure and functioning indicators}
