% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check}
\alias{check}
\title{check}
\usage{
check(
  x = NULL,
  y = NULL,
  z = NULL,
  field = NULL,
  edge = 0,
  filter = 1,
  resolution = NULL
)
}
\arguments{
\item{x}{Raster dataset. Required. Must be have a defined coordinate system.
If the coordinate system is not cartesian, the data will be projected onto
the Web Mercator (epsg: 3857) coordinate system before any analyses/tests.}

\item{y}{SpatialPolygonsDataFrame. Optional. Delineates the area within
which the raster layer shall be locally adapted and evaluted. Must be projected. If not
projected onto the same coordinate system as x, it will be reprojected to the
coordinate system of x. If not provided, the analyses willbe performed within
the intersect of the raster and the sampled area."}

\item{z}{SpatialPointsDataFrame. Required. Must have at least one column
with numerical data and these data must be of the same entity unit as the raster
(specify this column by argument: field). Must be projected. If not
projected to the same coordinate system as x, it will be reprojected to the
coordinate system of x.}

\item{field}{Character value. Required. Name of the column in
y with the data that shall be used to locally adapt and evaluate the raster}

\item{edge}{Numeric value. Optional. Specifies the width (m) of a
buffer zone inside the edge of the polygon that is excluded from the analyses.
Allowed values are within the closed range of 0-10000.}

\item{filter}{Positive integer. Optional. No of cells in the side of a square
window for mean filtering of x. Filtering is done before any resampling
(see argument: resolution). Allowed values are within the closed range of 1-20.}

\item{resolution}{Positive numeric value. Optional. The resolution (m) to
which the imported raster shall be resampled before the adaptation. Allowed
values are within the closed range of 0.1-10000. In addition, a resolution that
means more than 1E+8 raster cells is not allowed.}
}
\value{
A list with checked and corrected datasets together with a vector of logged feedback.
}
\description{
Checks attributes, geometries and projections of spatial datasets.
}
\details{
Intended for checking data in functions of mapsRinteractive.
}
\keyword{Internal}
