% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gsw_seasonality.R
\name{gsw_seasonality}
\alias{gsw_seasonality}
\alias{calc_gsw_seasonality}
\title{Calculate Global Surface Water (GSW) Seasonality}
\usage{
calc_gsw_seasonality()
}
\value{
A function that returns a tibble with one column \code{months}
and one column \code{area}, representing the area covered by each class in
ha.
}
\description{
GSW seasonality describes the intra-annual distribution of surface water for
each pixel. The raster files have integer cell values between \code{[0, 12]},
indicating how many months per year the pixel was classified as water.
}
\details{
The pixel values are aggregated using method provided via the
\code{stats} parameter.

The required resources for this indicator are:
\itemize{
\item \link{global_surface_water_seasonality}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_global_surface_water_seasonality()) \%>\%
  calc_indicators(calc_gsw_seasonality()) \%>\%
  tidyr::unnest(gsw_seasonality)

aoi
}
}
\keyword{indicator}
