% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_soilgrids.R
\docType{data}
\name{soilgrids}
\alias{soilgrids}
\title{Soildgrids data layers}
\format{
A global tiled raster resource available for all land areas.
}
\source{
\url{https://www.isric.org/explore/soilgrids}
}
\description{
Soilgrids is a project combining global observation data with
machine learning to map the spatial distribution of soil properties across
the globe. It is produced at a spatial resolution of 250 meters and each
parameters is mapped at different depths. In order to be able to assess
prediction uncertainty, besides the mean and median prediction, the 0.05 and
0.95 percentile predictions are available.
The following parameters are available:
\describe{
\item{bdod}{Bulk density of the fine earth fraction (kg/dm3)}
\item{cec}{Cation Exchange Capacity of the soil (cmol(c)/kg)}
\item{cfvo}{Volumetric fraction of coarse fragments > 2 mm (cm3/100cm3 (volPerc))}
\item{clay}{Proportion of clay particles < 0.002 mm in the fine earth fraction (g/100g)}
\item{nitrogen}{Total nitrogen (g/kg)}
\item{phh2o}{Soil pH (pH)}
\item{sand}{Proportion of sand particles > 0.05 mm in the fine earth fraction (g/100g)}
\item{silt}{Proportion of silt particles >= 0.002 mm and <= 0.05 mm in the fine earth fraction (g/100g)}
\item{soc}{Soil organic carbon content in the fine earth fraction (g/kg)}
\item{ocd}{Organic carbon density (kg/m3)}
\item{ocs}{Organic carbon stocks (kg/m²)}
}
}
\details{
Users can specify the following arguments:
\describe{
\item{layer}{The soil parameter as a single charachter}
\item{depth}{The requested depth as a single chrachter}
\item{stat}{The predicted statistic as a single charachter}
}

Except for \code{ocs}, which is only available for a depth of \code{"0-30cm"},
all other parameters are available at the following depths:
\itemize{
\item "0-5cm"
\item "5-15cm"
\item "15-30cm"
\item "30-60cm"
\item "60-100cm"
\item "100-200cm"
}

Each parameter and depth is available for the following statistics:
\itemize{
\item "Q0.05"
\item "Q0.50"
\item "mean"
\item "Q0.95"
}
}
\references{
Hengl T, Mendes de Jesus J, Heuvelink GBM, Ruiperez Gonzalez M,
Kilibarda M, et al. (2017) SoilGrids250m: Global gridded soil information
based on machine learning. PLOS ONE 12(2): e0169748.
\doi{https://doi.org/10.1371/journal.pone.0169748}
}
\keyword{resource}
