% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_lawfirm}
\alias{ison_lawfirm}
\title{One-mode lawfirm (Lazega 2001)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A multiplex, directed network with 71 nodes and 2571 arcs
#> # A tibble: 71 x 7
#>   status  gender office   seniority   age practice   school      
#>   <chr>   <chr>  <chr>        <dbl> <dbl> <chr>      <chr>       
#> 1 partner man    Boston          31    64 litigation Harvard/Yale
#> 2 partner man    Boston          32    62 corporate  Harvard/Yale
#> 3 partner man    Hartford        13    67 litigation Harvard/Yale
#> 4 partner man    Boston          31    59 corporate  Other       
#> 5 partner man    Hartford        31    59 litigation UConn       
#> 6 partner man    Hartford        29    55 litigation Harvard/Yale
#> # i 65 more rows
#> # A tibble: 2,571 x 3
#>    from    to type   
#>   <int> <int> <chr>  
#> 1     1     2 friends
#> 2     1     2 advice 
#> 3     1     4 friends
#> 4     1     8 friends
#> 5     1    17 friends
#> 6     1    17 advice 
#> # i 2,565 more rows
}\if{html}{\out{</div>}}
}
\source{
\code{{networkdata}}
}
\usage{
data(ison_lawfirm)
}
\description{
One-mode network dataset collected by Lazega (2001)
on the relations between partners in a corporate law firm called SG&R in New England 1988-1991.
This particular subset includes the 36 partners among the 71 attorneys of this firm.
Nodal attributes include seniority, formal status, office in which they work, gender, lawschool they attended,
their age, and how many years they had been at the firm.
}
\details{
The larger data from which this subset comes includes also individual performance measurements (hours worked, fees brought in)
and attitudes concerning various management policy options (see also \code{{sand}}),
their strong-coworker network, advice network, friendship network, and indirect control network.
}
\references{
Lazega, Emmanuel. 2001.
\emph{The Collegial Phenomenon: The Social Mechanisms of Cooperation Among Peers in a Corporate Law Partnership}.
Oxford: Oxford University Press.
}
\keyword{datasets}
