% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_mc_out.R
\name{print.mc_out}
\alias{print.mc_out}
\title{Print a \code{mc_out}-Class
Object}
\usage{
\method{print}{mc_out}(x, ...)
}
\arguments{
\item{x}{The output of \code{\link[=do_mc]{do_mc()}},
or any \code{mc_out}-class object
returned
by similar functions.}

\item{...}{Other arguments. Not
used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of the
output of \code{\link[=do_mc]{do_mc()}} or related
functions.
}
\examples{

library(lavaan)
data(data_med_mod_ab1)
dat <- data_med_mod_ab1
mod <-
"
m ~ x + w + x:w + c1 + c2
y ~ m + w + m:w + x + c1 + c2
"
fit <- sem(mod, dat)
# In real research, R should be 5000 or even 10000
mc_out <- do_mc(fit, R = 100, seed = 1234)

# Print the output of do_boot()
mc_out

}
