% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm2list.R
\name{lm2list}
\alias{lm2list}
\title{Join 'lm()' Output to Form an
'lm_list`-Class Object}
\usage{
lm2list(...)
}
\arguments{
\item{...}{The \code{\link[=lm]{lm()}} outputs to be
grouped in a list.}
}
\value{
It returns an \code{lm_list}-class
object that forms a path model
represented by a set of regression
models. This class has a \code{summary}
method that shows the summary of
each regression model stored (see
\code{\link[=summary.lm_list]{summary.lm_list()}}), and a \code{print}
method that prints the models stored
(see \code{\link[=print.lm_list]{print.lm_list()}}).
}
\description{
The resulting model can
be used by \code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, or
\code{\link[=cond_indirect]{cond_indirect()}} as a path method,
as if fitted by \code{\link[lavaan:sem]{lavaan::sem()}}.
}
\details{
If a path model with
mediation and/or moderation is fitted
by a set of regression models using
\code{\link[=lm]{lm()}}, this function can combine
them to an object of the class
\code{lm_list} that represents a path
model, as one fitted by structural
equation model functions such as
\code{\link[lavaan:sem]{lavaan::sem()}}. This class of object
can be used by some functions, such
as \code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, and
\code{\link[=cond_indirect]{cond_indirect()}} as if they were the
output of fitting a path model, with
the regression coefficients treated
as path coefficients.

The regression outputs to be combined
need to meet the following
requirements:
\itemize{
\item All models must be connected to at
least one another model. That is, a
regression model must either have (a)
at least on predictor that is the
outcome variable of another model, or
(b) its outcome variable the
predictor of another model.
\item All models must be fitted to the
same sample. This implies that the
sample size must be the same in all
analysis.
}
}
\examples{



data(data_serial_parallel)
lm_m11 <- lm(m11 ~ x + c1 + c2, data_serial_parallel)
lm_m12 <- lm(m12 ~ m11 + x + c1 + c2, data_serial_parallel)
lm_m2 <- lm(m2 ~ x + c1 + c2, data_serial_parallel)
lm_y <- lm(y ~ m11 + m12 + m2 + x + c1 + c2, data_serial_parallel)
# Join them to form a lm_list-class object
lm_serial_parallel <- lm2list(lm_m11, lm_m12, lm_m2, lm_y)
lm_serial_parallel
summary(lm_serial_parallel)

# Compute indirect effect from x to y through m11 and m12
outm11m12 <- cond_indirect(x = "x", y = "y",
                           m = c("m11", "m12"),
                           fit = lm_serial_parallel)
outm11m12
# Compute indirect effect from x to y
# through m11 and m12 with bootstrapping CI
# R should be at least 2000 or even 5000 in read study.
# In real research, parallel and progress can be omitted.
# They are est to TRUE by default.
outm11m12 <- cond_indirect(x = "x", y = "y",
                           m = c("m11", "m12"),
                           fit = lm_serial_parallel,
                           boot_ci = TRUE,
                           R = 100,
                           seed = 1234,
                           parallel = FALSE,
                           progress = FALSE)
outm11m12

}
\seealso{
\code{\link[=summary.lm_list]{summary.lm_list()}} and
\code{\link[=print.lm_list]{print.lm_list()}} for related
methods, \code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}} which
accept \code{lm_list}-class objects as
input.
}
