% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.indirect_list.R
\name{as_flextable.indirect_list}
\alias{as_flextable.indirect_list}
\title{Convert an 'indirect_list' Object to a 'flextable' Object}
\usage{
\method{as_flextable}{indirect_list}(
  x,
  pvalue = FALSE,
  se = TRUE,
  var_labels = NULL,
  digits = 2,
  pval_digits = 3,
  use_arrow = TRUE,
  indirect_raw = TRUE,
  indirect_raw_ci = indirect_raw,
  indirect_raw_se = indirect_raw,
  group_by_x = TRUE,
  group_by_y = TRUE,
  y_first = TRUE,
  total_indirect = TRUE,
  footnote = TRUE,
  pcut = 0.001,
  ...
)
}
\arguments{
\item{x}{The object to be converted.
Should be of the class \code{indirect_list}
from the package \code{manymome}.}

\item{pvalue}{If bootstrap confidence
intervals are stored, whether
asymmetric \emph{p}-values are reported.
Default is \code{FALSE}.
See
\code{manymome::print.indirect_list()}
for the computational details.}

\item{se}{Whether standard errors
are reported if confidence intervals
are stored. Default is \code{TRUE}.
See
\code{manymome::print.indirect_list()}
for the computation details.}

\item{var_labels}{A named vectors.
Used to replace variable names by
other names when generating the
table. For example,
\code{c(x = "I.V", y = "D.V.")} replaces
\code{x} by \code{"I.V"} and \code{y} by \code{"D.V."}
in the output.}

\item{digits}{The number of digits
to be displayed for most numerical
columns,
such as effect estimates, standard
errors, and confidence intervals.
Default is 2.}

\item{pval_digits}{The number of
digits to be displayed for the
\emph{p}-value column, if present. Default
is 3.}

\item{use_arrow}{If \code{TRUE}, the
default, use the arrow symbol in
the paths.}

\item{indirect_raw}{If \code{TRUE}, the
default, report unstandardized effects
even if standardization was done.}

\item{indirect_raw_ci}{If \code{TRUE},
report the confidence intervals
of unstandardized effects
even if standardization was done
and confidence intervals were stored.
Default to be equal to \code{indirect_raw}.
NOTE: Not used for now. Always \code{FALSE}.}

\item{indirect_raw_se}{If \code{TRUE},
report the standard errors
of unstandardized effects
even if standardization was done
and confidence intervals were stored.
Default to be equal to \code{indirect_raw}.
NOTE: Not used for now. Always \code{FALSE}.}

\item{group_by_x}{If \code{TRUE}, the
default, the rows will be grouped by
x-variables if the paths have more
than one x-variable.  Default is \code{TRUE}.}

\item{group_by_y}{If \code{TRUE}, the
default, the rows will be grouped by
y-variables if the paths have more than
one y-variable. Default is \code{TRUE}.}

\item{y_first}{If group by both
x- and y-variables, group by
y-variables first if \code{TRUE}, the
default.
Otherwise, group by x-variables.}

\item{total_indirect}{If \code{TRUE}, the
default, total indirect effect
will be computed and added to
the output.}

\item{footnote}{If \code{TRUE}, the
default,
add footnote(s) regarding the results
to the bottom of the table.}

\item{pcut}{Any \emph{p}-value less than
\code{pcut} will be displayed as
\verb{<[pcut]}, \code{"[pcut]"} replaced by
the value of \code{pcut}. Default is .001.}

\item{...}{Additional arguments.
Ignored.}
}
\value{
A \code{flextable} object.
}
\description{
The 'as_flextable' method
for the output of 'manymome::many_indirect_effects()'.
}
\details{
It converts an \code{indirect_list}
object,
which is usually created by
\code{\link[manymome:cond_indirect]{manymome::many_indirect_effects()}},
to a \code{flextable} object. The output
can be further modified by functions
from the package \code{flextable}.
}
\examples{

library(flextable)
library(manymome)

data(data_med_complicated)
lm_m11 <- lm(m11 ~ x1 + x2, data_med_complicated)
lm_m2 <- lm(m2 ~ x1 + x2, data_med_complicated)
lm_y1 <- lm(y1 ~ m11 + m2 + x1 + x2, data_med_complicated)
fit <- lm2list(lm_m11, lm_m2, lm_y1)

# All indirect paths
paths <- all_indirect_paths(fit,
                           x = c("x1", "x2"),
                           y = c("y1"))

# Indirect paths from x1 to y1
paths_x1y1 <- all_indirect_paths(fit,
                           x = c("x1"),
                           y = c("y1"))

# Indirect effect estimates
ind <- many_indirect_effects(paths,
                             fit = fit)
ft_ind <- as_flextable(ind)
ft_ind
ft_ind <- as_flextable(ind, group_by_x = FALSE)
ft_ind

ind_x1y1 <- many_indirect_effects(paths_x1y1,
                                  fit = fit)
ft_ind_x1y1 <- as_flextable(ind_x1y1)
ft_ind_x1y1

# Should set R to 5000 or 10000 in real research
boot_out_lm <- do_boot(fit,
                       R = 100,
                       seed = 54532,
                       parallel = FALSE,
                       progress = FALSE)
ind_x1y1_ci <- many_indirect_effects(paths_x1y1,
                                     fit = fit,
                                     boot_ci = TRUE,
                                     boot_out = boot_out_lm)
ft_ind_x1y1_ci <- as_flextable(ind_x1y1_ci)
ft_ind_x1y1_ci

}
